proc()=writelist(x, filename)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     readlist readmatrix
; -----------------------------------------------------------------------
; Macro        writelist
; -----------------------------------------------------------------------
; Description  Writes a composed object as ASCII data to a set of files.
;              All elements of the composed object have to be numerical
;              matrices or textvectors !
; -----------------------------------------------------------------------
; Usage        writelist (obj, filename)
; Input
;   Parameter  obj
;   Definition composed object
;   Parameter  filename
;   Definition string
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              writelist (grc, "mygrc")
;              mygrc = readlist ("mygrc")
;              mygrc
; -----------------------------------------------------------------------
; Result       grc is a composed object that is created by the call of
;              graphic library. writelist creates a set of files 
;              beginning with "mygrc" which contains the elements
;              of the list.
;              "readlist" reads the set of files into mygrc. The printout
;              shows that grc and mygrc have the same structure and
;              contents.
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971030, 971107
; -----------------------------------------------------------------------
  error(exist("x")<>9, "writelist : list expected")
  lof = filename
  lot = 0
  ln  = names(x)
  i   = 0
  while (i<rows(ln))
    i = i+1
    {lof, lot} = writecomponent (x{i}, filename+"."+ln[i], lof, lot)
  endo
  lof = string ("%.0f ", lot) + lof
  write (lof, filename, "%s")
endp
;
