proc(wts)=wtsder(d,m,d1)
; -----------------------------------------------------------------
; Library       metrics
; -----------------------------------------------------------------
;  See_also      adeind adeslp
; -----------------------------------------------------------------
;   Macro        wtsder
; -----------------------------------------------------------------
;   Keywords     weighting, kernel estimation, average derivative, binning
; -----------------------------------------------------------------
;   Description  computes the weights for derivative estimation for
;                the use with the quatric kernel   
;                in the context of binning
; -----------------------------------------------------------------
;   Usage        wts = wtsder(d,m,d1)    
;   Input
;     Parameter   d  
;     Definition      scalar , the dimension of the variable
;     Parameter   m
;     Definition      d x 1 vector or scalar , discretization parameter
;     Parameter   d1
;     Definition      scalar , the coordinate in which the derivative is
;                              calculated
;   Output                                                                   
;     Parameter   wts
;     Definition      k x 1 matrix , 
; -----------------------------------------------------------------
;   Example   library("metrics")
;             d = 3
;             d1= 2
;             m = 5
;             wts = wtsder(d,m,d1)
;             wts 
; -----------------------------------------------------------------
;   Result    the computed weights for derivative estimation that is
;             using the quatric kernel
; -----------------------------------------------------------------
;   Author    Sperlich & Stockmeyer 960730  
; -----------------------------------------------------------------

  error(d1>d,"Error in wtsder.xpl: d1>d")
  wts= matrix(d,1)*0
  f  = grid(wts,matrix(rows(wts)),matrix(rows(wts)).*(m+1))
  s  = 2^sum((f.<>0),2).*f[,d1]                    
  f  = f./m'
  wts= 0.9375*(1-f^2)^2 .*(abs(f).<1)
  f  = f[,d1]
  wts[,d1] = -3.75 .*f .*(1-f^2) .*(abs(f).<1)
  wts= prod(wts,2)
  s  = -sum((s .*wts),1)
  wts= wts/s
endp
  
