; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         flts11
; ----------------------------------------------------------------------------
; Description   plots original and logged time series of exchange rates
; ----------------------------------------------------------------------------
  library("plot")
  library("times")
  setsize(640,480)
  fx		= read("dmus58-300.dat"); read data
  d1 		= createdisplay(1,1)
  x1		= #(1:300)~fx
  setmaskl (x1, (1:rows(x1))', 0, 1) 
  show(d1,1,1,x1)			; plot data
  setgopt(d1,1,1,"title","20 min. spaced sample of logged DM/US-Dollar rates")
  setgopt(d1,1,1,"xlabel","Periods","ylabel","levels")
	
  d2		= createdisplay(1,1)
  x2		= #(2:300)~tdiff(fx)
  setmaskl (x2, (1:rows(x2))', 0, 1) 
  show(d2,1,1,x2)			; plot data
  setgopt(d2,1,1,"title","20 min. spaced sample of DM/US-Dollar returns")
  setgopt(d2,1,1,"xlabel","Periods","ylabel","first differences")
