; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      backfit
; ----------------------------------------------------------------------------
; Macro         gam04
; ----------------------------------------------------------------------------
; Description   estimates additive or additive partially linear model
;		for simulated data using backfitting
; ----------------------------------------------------------------------------
library("gam")
randomize(1)
n   = 100
t   = normal(n,2)             ; explanatory variable
x   = normal(n,2)             ; the linear part
f1  = - sin(2*t[,1])          ; estimated functions
f2  = t[,2]^2
eps = normal(n,1) * sqrt(0.75)
y   = x[,1] - x[,2]/4 + f1 + f2 +eps      ; response variable
h   = 0.5
opt = gamopt("x",x,"shf",1)   ; the linear part is used
;                               and the iterations will be shown
{m,b,const} = backfit(t,y,h,0,"qua",opt)
;
b                             ; coefficients for the linear part ([1, -1/4] were used)
const                         ; estimation of the constant
;
pic = createdisplay(1,2)      ; preparing the graphical output
d1  = t[,1]~m[,1]
d2  = t[,2]~m[,2]
setmaskp(d1,4,4,4)
setmaskp(d2,4,4,4)
m1  = mean(f1)
m2  = mean(f2)
yy  = y - x*b - const
x1  = t[,1]~(yy - m[,2])
x2  = t[,2]~(yy - m[,1])
setmaskp(x1,1,11,4)
setmaskp(x2,1,11,4)
setmaskl(d1,(sort(d1~(1:rows(d1)))[,3])',4,1,1)
setmaskl(d2,(sort(d2~(1:rows(d2)))[,3])',4,1,1)
show(pic,1,1,d1,x1,t[,1]~(f1-m1))
show(pic,1,2,d2,x2,t[,2]~(f2-m2))
