; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      haztest
; ----------------------------------------------------------------------------
; Macro         haz10
; ----------------------------------------------------------------------------
; Description   hazard regression analysis for length of stay in nursing homes
; ----------------------------------------------------------------------------
library("hazreg")
dat=read("nursing.dat")
t = dat[,1]
delta = dat[,2]
age = dat[,3]
gender = dat[,4]
married = dat[,5]

limit = matrix(rows(dat), 1)*90           ; transform AGE
agespline = min(age~limit,2) - 65

z = agespline~gender~married
{data, ties} = hazdat(t, delta, z)        ; prepare data
{betahat, betak, ck}=hazbeta(data)        ; estimate beta
betahat
{ll, ll1, ll2} = hazregll(data, betahat)
sigma = inv(ll2)                          ; estimate SE(beta)
sigma
{ttest1, val1, df1, pval1} = haztest(data, (0|1|1))
ttest1
{ttest2, val2, df2, pval2} = haztest(data, (1|0|1))
ttest2
{ttest3, val3, df3, pval3} = haztest(data, (1|1|0))
ttest3
