; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         qr06
; ----------------------------------------------------------------------------
; Description   regression rank score test
; ----------------------------------------------------------------------------
  library("metrics")
;
; simulate data matrix
;
  n = 100
  randomize(1101)
  x = matrix(n) ~ uniform(n,2)
;
; generate y1 and y2
;
  y1 = x[,1] + 2*x[,2] - x[,3] + normal(n)
  y2 = x[,1] + 2*x[,2] + normal(n)
;
; test the hypothesis that the coefficient of x[,3] is zero
;
; first case
  chi1 = rrstest(x[,1:2], x[,3], y1)
  chi1
  cdfc(chi1,1)
; second case
  chi2 = rrstest(x[,1:2], x[,3], y2)
  chi2
  cdfc(chi2,1)

