proc(yh)=xgobilocpol(x,y,g,h)
; -----------------------------------------------------------------------
; Library      rpclib
; -----------------------------------------------------------------------
; See_also     xgobilowess xgobinadawat xgobineunet
; -----------------------------------------------------------------------
; Macro        xgobilocpol
; -----------------------------------------------------------------------
; Description  conmputes a local polynomial or order 3 fit for XGobi
; -----------------------------------------------------------------------
; Usage        yh = xgobilocpol(x,y,g,h)
; Input
;   Parameter  x
;   Definition n x 1    matrix
;   Parameter  y
;   Definition n x 1    matrix
;   Parameter  g
;   Definition n x 1    matrix with integers starting at zero
;   Parameter  h
;   Definition scalar   bandwidth
; Output
;   Parameter  yh
;   Definition n x 1    matrix smoothed fit
; -----------------------------------------------------------------------
; Notes        XGobi gives h as negative number which allows the user
;	       to use the macro for other purposes. We expect that XGobi
;              sets h between -333 and -3900.
; -----------------------------------------------------------------------
; Example      ; load the library for XGobi
;	       library ("rpclib")
;              ; create a display
;	       d=createdisplay(1,1)
;	       ; read a data set
;  	       x=read("motcyc")
;              ; generate randomly three subgroups
;  	       g=floor(3.*uniform(rows(x)))
;              ; color the data after the subgroups
;              setmaskp (x, g, 3, 4)
;              ; show the data and the smooth
;              show (d, 1, 1, x, x[,1]~xgobilocpol(x[,1],x[,2],g,10))
; -----------------------------------------------------------------------
; Result       shows a local polynomial fit of order 3 for the three 
;	       different subgroups in the data
; -----------------------------------------------------------------------
; Link         http://www.public.iastate.edu/~dicook/research/software.html XGobi
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960709
; -----------------------------------------------------------------------
  if (h<0)
    h = abs(h)/8000
    string ("bandwidth  : %.3f", h) 
  endif
  i  = 0
  mg = 1+max(g)
  yh = y
  k  = 1:rows(x)
  while (i<mg)
    xg = paf(x, g.=i)
    yg = paf(y, g.=i)
    kg = paf(k, g.=i)
    xg = sort(xg~yg~kg)
    yg = xg[,2]
    kg = xg[,3]
    xg = xg[,1]
    hg = h*(max(xg)-min(xg))
    yg = lpregest (xg~yg, hg, 3)
    kn = mknn(yg[,1], 1, xg)
    yh[kg] = yg[kn,2]
    i = i+1
  endo
endp
