; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph24
; -----------------------------------------------------------------
;   Description  Coloring data points.
; -----------------------------------------------------------------
  library("plot")                ; loads library plot
  xmin = 0                       ; grid minimum 
  xmax = 2*pi                    ; grid maximum
  n  = 100                       ; number of grid points
  x  = xmin + (xmax-xmin)/(n-1) .* (0:n-1)  ; generates grid
  y1 = sin(x)                    ; computes sin(x)
  y2 = sin(3.*x)                 ; computes sin(3x)
  y3 = sin(6.*x)                 ; computes sin(6x)
  z1 = setmask(x~y1, "red")      ; colors sin(x) red
  z2 = setmask(x~y2, "green")    ; colors sin(x) green
  z3 = setmask(x~y3, "blue")     ; colors sin(x) blue
  plot(z1, z2, z3)               ; plots data sets



