; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph42
; -----------------------------------------------------------------
;   Description  Surface of the bivariate normal density.
; -----------------------------------------------------------------
  library ("plot")               ; loads library plot
  x0 = #(-3, -3)              
  h  = #(0.2, 0.2)
  n  = #(31, 31)
  x  = grid(x0, h, n)            ; generates a bivariate grid
  f  = exp(-(x[,1]^2+x[,2]^2)/1.5)/(1.5*pi)
                                 ; computes density of bivariate 
                                 ;   normal with correlation 0.5
  gr = grsurface(x~f)            ; generates surface
  plot(gr)                       ; plots the surface
