; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph65
; -----------------------------------------------------------------
;   Description  Generating lines by graphic commands.
; -----------------------------------------------------------------
  randomize(666)          ; sets seed for random number generator
  n = 6                   ; sample size
  x = 4:(3+n)             ; generates x-variable as 4,...,9
  y = 2*x+normal(n)       ; generates y-variable
  z = x~y                 ; composes data matrix
  d = createdisplay(1, 1) ; creates display
  ;
  ; now we will create a row vector pm that tells setmaskl to 
  ; connect all 6 points of the data matrix in the same order 
  ; as they appear
  ;
  pm    = (1:n)'          ; generates row vector 1,...,6
  color = 1               ; blue line
  art   = 1               ; solid line
  thick = 5               ; thick line
  setmaskl(z, pm, color ,art ,thick) ; call setmaskl
  show(d, 1, 1, z)        ; call show to plot the data
