; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph66
; -----------------------------------------------------------------
;   Description  Mixed lines and data points by graphic commands.
; -----------------------------------------------------------------
  randomize(666)          ; sets seed for random number generator
  n = 6                   ; sample size
  x = 4:(3+n)             ; generates x-variable as 4,...,9
  y = 2*x+normal(n)       ; generates y-variable
  z = x~y                 ; composes data matrix
  pm    = (1~3~5)|(2~4~6) 
  color = 1|4             ; sets color of first line to blue (=1)
                          ;    and of second line to red (=4)
  art   = 1|2             ; first line will be solid (=1), 
                          ;    second line will be dashed (=2)
  setmaskl(z, pm, color, art) 
                          ; calls setmaskl
  d = createdisplay(1, 1) ; creates a display
  show(d, 1, 1, z)        ; calls show to plot data
