; -----------------------------------------------------------------
; Library        GLM
; -----------------------------------------------------------------
;   Macro        glm05
; -----------------------------------------------------------------
;   Description  Non-interactive GLM estimation (logit model)
;                with hypothesis testing.
; -----------------------------------------------------------------
  library("glm")
;
  x = read("lizard")
  x = paf(x,(x[,6]!=0))
  y = x[,5]
  m = x[,6]
  x = matrix(rows(x))~x[,1:3]~(x[,4]==1)~(x[,4]==2)
;
  opt=glmopt("wx",m)
  g=glmest("bilo",x,y,opt)       ; full model
;
  tvalue=g.b/sqrt(xdiag(g.bv))
  pvalue=2.*cdfn(-abs(tvalue))
  pvalue                         ; pvalue for coefficients   
;
  A=2 ~ (-1) ~ 0.*matrix(rows(g.b)-2)'
  a=0
  W=(A*g.b-a)'*(A*g.bv*A')*(A*g.b-a)
  pvalue=1-cdfc(W,1)
  pvalue                         ; pvalue for 2*b[1]=b[2]
;
  offset=-x[,6]                  ; constraint b[6]=-1
  opt=glmopt("off",offset,opt)
  c=glmest("bilo",x[,1:5],y,opt) ; constrained model
;
  lc=c.stat.loglik
  lg=g.stat.loglik
  pc=rows(c.b)
  pg=rows(g.b)
  {lr,pvalue}=glmlrtest(lc,pc,lg,pg)
  pvalue                         ; pvalue for constraint model
