; -----------------------------------------------------------------
; Library        GRAPH
; -----------------------------------------------------------------
;   Macro        graph51
; -----------------------------------------------------------------
;   Description  Parallel boxplots of several variables.
; -----------------------------------------------------------------
  library("plot")                ; loads library plot
  data = read ("bostonh")        ; reads Boston Housing data
  gro1 = grbox (data[,11])       ; boxplot of 11th variable
  gro2 = grbox (data[,13])       ; boxplot of 13th variable
  gro3 = grbox (data[,14])       ; boxplot of 14th variable
  gro1 = grrot (gro1, 1)         ; rotates first boxplot
  gro2 = grrot (gro2, 1)         ; rotates second boxplot
  gro2 = grmove (gro2, #(1.5,0)) ; moves second boxplot 1.5 right
  gro3 = grrot (gro3, 1)         ; rotates the third boxplot
  gro3 = grmove (gro3, #(3,0))   ; moves third boxplot 3.0 right
  plot(gro1, gro2, gro3)         ; shows the boxplots




