; -----------------------------------------------------------------



; Library        GRAPH



; -----------------------------------------------------------------



;   Macro        graph54



; -----------------------------------------------------------------



;   Description Contour plot of the density of the standard bivariate



;               normal distribution colored after a HLS color scheme.



; -----------------------------------------------------------------



  library("plot")              ; loads the library plot



  h   = grid (120,13.3333,9)   ; creates grid in HLS double cone



  l   = 0.5.*matrix(rows(h))



  s   = matrix(rows(h))



  rgb = hls2rgb(h~l~s)         ; transfers HLS model to RGB model



  x0 = #(-3, -3)



  h  = #(0.1, 0.1)



  n  = #(61, 61)



  x  = grid(x0, h, n)          ; generates a bivariate grid



  f  = exp(-(x[,1]^2+x[,2]^2)/1.5)/(1.5*pi)  



                               ; computes density of bivariate 



                               ;    normal with correlation 0.5



  c  = 0.1*(1:9).*max(f)       ; contour lines as 10%,...,90% 



                               ;    times the maximum density



  createcolor(rgb)             ; generates the necessary colors



  gr = grcontour2(x~f, c, rgb) ; generates surface



  plot(gr)                     ; plots the surface



