; -----------------------------------------------------------------
; Library        QUANT
; -----------------------------------------------------------------
;   Macro        quant05
; -----------------------------------------------------------------
;   Description  Example quantlet procedure with input parameter, 
;                which allows to show an outlier in linear regression.
; -----------------------------------------------------------------
  proc() = myquant(obs1)
    n = 10                   ; number of observations
    randomize(17654321)      ; sets random seed
    beta =#(1, 2)            ; defines intercept and slope
    x = matrix(n)~sort(uniform(n))  
                             ; creates design matrix   
  // new x-observation is
    x = x|(1~obs1[1])
    m = x*beta               ; defines regression line
    eps = 0.05*normal(n)     ; creates obs error
  // new y-observation 
    y = m[1:n] + eps         ; noisy line
    y = y|obs1[2]
    d = createdisplay(1,1)     
    dat = x[,2]~y                              
    outl = obs1[1]~obs1[2]
    setmaskp(outl,0,12,8)    ; outlier is black star
    tdat = x[,2]~m
    setmaskl(tdat, (1:rows(tdat))', 1, 1, 1) 
                             ; thin blue line
    setmaskp(tdat, 0, 0, 0)  ; reduces point size to min
    beta1 = inv(x'*x)*x'*y
    yhat = x*beta1
    hdat = x[,2]~yhat
    setmaskp(hdat, 0, 0, 0)    
    setmaskl(hdat, (1:rows(hdat))', 4, 1, 3)
                             ; thick red line
    show(d, 1, 1, dat[1:n], outl, tdat, hdat)
    title="Least squares regression with outlier"
    setgopt(d,1,1,"title",title)
                             ; sets title 
  endp
