; -----------------------------------------------------------------
; Library        START
; -----------------------------------------------------------------
;   Macro        start05
; -----------------------------------------------------------------
;   Description  Example quantlet which reads data, and plots
;                a two-dimensional density estimate.
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  x = read("bank2")
  x=x[,5:6] 
  fh = denxestp(x)
  fh = setmask(fh,"surface","blue")
  axesoff()
  cu = grcube(fh)              ; box
  plot(cu.box,cu.x,cu.y, fh)   ; plot box and fh
  setgopt(plotdisplay,1,1,"title","2D Density Estimate")
  axeson()
