; -----------------------------------------------------------------
; Library        XTRM
; -----------------------------------------------------------------
;   Macro        xtrm02
; -----------------------------------------------------------------
;   Description  Plots empirical mean excess function and parametric
;                ones fitted by Hill(GP1) and Moment(GP) estimator
;		 to dyr.dat
; -----------------------------------------------------------------
;   Notes        Please use dyr1000.dat instead of dyr.dat, if you
;                have the XploRe Academic Edition.
; -----------------------------------------------------------------
library("finance")
library("xplore")
;
dyr=read("dyr.dat")
dyr=-dyr
;
h=hillgp1(dyr,160)
m=momentgp(dyr,160)
t=aseq(0.009,210,0.0001)
;
setsize(640,480)
d=createdisplay(1,1)
;
; plot empirical mean excess function
;
et=sort(dyr)[rows(dyr)-160:rows(dyr)-1]
eme=et~empme(dyr,et)
eme=setmask(eme,"line","black","thin","solid")
show(d,1,1,eme)
;
hme=t~gp1me(h.alpha,t/h.sigma)*h.sigma
hme=setmask(hme,"line","black","thin","dotted")
adddata(d,1,1,hme)
;
mme=t~gpme(m.gamma,(t-m.mu)/m.sigma)*m.sigma
mme=setmask(mme,"line","black","thin","dashed")
adddata(d,1,1,mme)
;
setgopt(d,1,1,"xvalue",0|1,"yvalue",0|1)
