/* minfit.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static doublereal c_b39 = 1.;

/* Subroutine */ int minfit_(nm, m, n, a, w, ip, b, ierr, rv1)
integer *nm, *m, *n;
doublereal *a, *w;
integer *ip;
doublereal *b;
integer *ierr;
doublereal *rv1;
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, i__1, i__2, i__3;
    doublereal d__1, d__2, d__3, d__4;

    /* Builtin functions */
    double sqrt(), d_sign();

    /* Local variables */
    static doublereal c, f, g, h;
    static integer i, j, k, l;
    static doublereal s, x, y, z, scale;
    static integer i1, k1, l1, m1, ii, kk, ll;
    extern doublereal pythag_();
    static integer its;
    static doublereal tst1, tst2;



/*     this subroutine is a translation of the algol procedure minfit, */
/*     num. math. 14, 403-420(1970) by golub and reinsch. */
/*     handbook for auto. comp., vol ii-linear algebra, 134-151(1971). */

/*     this subroutine determines, towards the solution of the linear */
/*                                                        t */
/*     system ax=b, the singular value decomposition a=usv  of a real */
/*                                         t */
/*     m by n rectangular matrix, forming u b rather than u.  householder 
*/
/*     bidiagonalization and a variant of the qr algorithm are used. */

/*     on input */

/*        nm must be set to the row dimension of two-dimensional */
/*          array parameters as declared in the calling program */
/*          dimension statement.  note that nm must be at least */
/*          as large as the maximum of m and n. */

/*        m is the number of rows of a and b. */

/*        n is the number of columns of a and the order of v. */

/*        a contains the rectangular coefficient matrix of the system. */

/*        ip is the number of columns of b.  ip can be zero. */

/*        b contains the constant column matrix of the system */
/*          if ip is not zero.  otherwise b is not referenced. */

/*     on output */

/*        a has been overwritten by the matrix v (orthogonal) of the */
/*          decomposition in its first n rows and columns.  if an */
/*          error exit is made, the columns of v corresponding to */
/*          indices of correct singular values should be correct. */

/*        w contains the n (non-negative) singular values of a (the */
/*          diagonal elements of s).  they are unordered.  if an */
/*          error exit is made, the singular values should be correct */
/*          for indices ierr+1,ierr+2,...,n. */

/*                                   t */
/*        b has been overwritten by u b.  if an error exit is made, */
/*                       t */
/*          the rows of u b corresponding to indices of correct */
/*          singular values should be correct. */

/*        ierr is set to */
/*          zero       for normal return, */
/*          k          if the k-th singular value has not been */
/*                     determined after 30 iterations. */

/*        rv1 is a temporary storage array. */

/*     calls pythag for  dsqrt(a*a + b*b) . */

/*     questions and comments should be directed to burton s. garbow, */
/*     mathematics and computer science div, argonne national laboratory 
*/

/*     this version dated august 1983. */

/*     ------------------------------------------------------------------ 
*/

    /* Parameter adjustments */
    --rv1;
    --w;
    a_dim1 = *nm;
    a_offset = a_dim1 + 1;
    a -= a_offset;
    b_dim1 = *nm;
    b_offset = b_dim1 + 1;
    b -= b_offset;

    /* Function Body */
    *ierr = 0;
/*     .......... householder reduction to bidiagonal form .......... */
    g = 0.;
    scale = 0.;
    x = 0.;

    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	l = i + 1;
	rv1[i] = scale * g;
	g = 0.;
	s = 0.;
	scale = 0.;
	if (i > *m) {
	    goto L210;
	}

	i__2 = *m;
	for (k = i; k <= i__2; ++k) {
/* L120: */
	    scale += (d__1 = a[k + i * a_dim1], abs(d__1));
	}

	if (scale == 0.) {
	    goto L210;
	}

	i__2 = *m;
	for (k = i; k <= i__2; ++k) {
	    a[k + i * a_dim1] /= scale;
/* Computing 2nd power */
	    d__1 = a[k + i * a_dim1];
	    s += d__1 * d__1;
/* L130: */
	}

	f = a[i + i * a_dim1];
	d__1 = sqrt(s);
	g = -d_sign(&d__1, &f);
	h = f * g - s;
	a[i + i * a_dim1] = f - g;
	if (i == *n) {
	    goto L160;
	}

	i__2 = *n;
	for (j = l; j <= i__2; ++j) {
	    s = 0.;

	    i__3 = *m;
	    for (k = i; k <= i__3; ++k) {
/* L140: */
		s += a[k + i * a_dim1] * a[k + j * a_dim1];
	    }

	    f = s / h;

	    i__3 = *m;
	    for (k = i; k <= i__3; ++k) {
		a[k + j * a_dim1] += f * a[k + i * a_dim1];
/* L150: */
	    }
	}

L160:
	if (*ip == 0) {
	    goto L190;
	}

	i__3 = *ip;
	for (j = 1; j <= i__3; ++j) {
	    s = 0.;

	    i__2 = *m;
	    for (k = i; k <= i__2; ++k) {
/* L170: */
		s += a[k + i * a_dim1] * b[k + j * b_dim1];
	    }

	    f = s / h;

	    i__2 = *m;
	    for (k = i; k <= i__2; ++k) {
		b[k + j * b_dim1] += f * a[k + i * a_dim1];
/* L180: */
	    }
	}

L190:
	i__2 = *m;
	for (k = i; k <= i__2; ++k) {
/* L200: */
	    a[k + i * a_dim1] = scale * a[k + i * a_dim1];
	}

L210:
	w[i] = scale * g;
	g = 0.;
	s = 0.;
	scale = 0.;
	if (i > *m || i == *n) {
	    goto L290;
	}

	i__2 = *n;
	for (k = l; k <= i__2; ++k) {
/* L220: */
	    scale += (d__1 = a[i + k * a_dim1], abs(d__1));
	}

	if (scale == 0.) {
	    goto L290;
	}

	i__2 = *n;
	for (k = l; k <= i__2; ++k) {
	    a[i + k * a_dim1] /= scale;
/* Computing 2nd power */
	    d__1 = a[i + k * a_dim1];
	    s += d__1 * d__1;
/* L230: */
	}

	f = a[i + l * a_dim1];
	d__1 = sqrt(s);
	g = -d_sign(&d__1, &f);
	h = f * g - s;
	a[i + l * a_dim1] = f - g;

	i__2 = *n;
	for (k = l; k <= i__2; ++k) {
/* L240: */
	    rv1[k] = a[i + k * a_dim1] / h;
	}

	if (i == *m) {
	    goto L270;
	}

	i__2 = *m;
	for (j = l; j <= i__2; ++j) {
	    s = 0.;

	    i__3 = *n;
	    for (k = l; k <= i__3; ++k) {
/* L250: */
		s += a[j + k * a_dim1] * a[i + k * a_dim1];
	    }

	    i__3 = *n;
	    for (k = l; k <= i__3; ++k) {
		a[j + k * a_dim1] += s * rv1[k];
/* L260: */
	    }
	}

L270:
	i__3 = *n;
	for (k = l; k <= i__3; ++k) {
/* L280: */
	    a[i + k * a_dim1] = scale * a[i + k * a_dim1];
	}

L290:
/* Computing MAX */
	d__3 = x, d__4 = (d__1 = w[i], abs(d__1)) + (d__2 = rv1[i], abs(d__2))
		;
	x = max(d__3,d__4);
/* L300: */
    }
/*     .......... accumulation of right-hand transformations. */
/*                for i=n step -1 until 1 do -- .......... */
    i__1 = *n;
    for (ii = 1; ii <= i__1; ++ii) {
	i = *n + 1 - ii;
	if (i == *n) {
	    goto L390;
	}
	if (g == 0.) {
	    goto L360;
	}

	i__3 = *n;
	for (j = l; j <= i__3; ++j) {
/*     .......... double division avoids possible underflow ......
.... */
/* L320: */
	    a[j + i * a_dim1] = a[i + j * a_dim1] / a[i + l * a_dim1] / g;
	}

	i__3 = *n;
	for (j = l; j <= i__3; ++j) {
	    s = 0.;

	    i__2 = *n;
	    for (k = l; k <= i__2; ++k) {
/* L340: */
		s += a[i + k * a_dim1] * a[k + j * a_dim1];
	    }

	    i__2 = *n;
	    for (k = l; k <= i__2; ++k) {
		a[k + j * a_dim1] += s * a[k + i * a_dim1];
/* L350: */
	    }
	}

L360:
	i__2 = *n;
	for (j = l; j <= i__2; ++j) {
	    a[i + j * a_dim1] = 0.;
	    a[j + i * a_dim1] = 0.;
/* L380: */
	}

L390:
	a[i + i * a_dim1] = 1.;
	g = rv1[i];
	l = i;
/* L400: */
    }

    if (*m >= *n || *ip == 0) {
	goto L510;
    }
    m1 = *m + 1;

    i__1 = *n;
    for (i = m1; i <= i__1; ++i) {

	i__2 = *ip;
	for (j = 1; j <= i__2; ++j) {
	    b[i + j * b_dim1] = 0.;
/* L500: */
	}
    }
/*     .......... diagonalization of the bidiagonal form .......... */
L510:
    tst1 = x;
/*     .......... for k=n step -1 until 1 do -- .......... */
    i__2 = *n;
    for (kk = 1; kk <= i__2; ++kk) {
	k1 = *n - kk;
	k = k1 + 1;
	its = 0;
/*     .......... test for splitting. */
/*                for l=k step -1 until 1 do -- .......... */
L520:
	i__1 = k;
	for (ll = 1; ll <= i__1; ++ll) {
	    l1 = k - ll;
	    l = l1 + 1;
	    tst2 = tst1 + (d__1 = rv1[l], abs(d__1));
	    if (tst2 == tst1) {
		goto L565;
	    }
/*     .......... rv1(1) is always zero, so there is no exit */
/*                through the bottom of the loop .......... */
	    tst2 = tst1 + (d__1 = w[l1], abs(d__1));
	    if (tst2 == tst1) {
		goto L540;
	    }
/* L530: */
	}
/*     .......... cancellation of rv1(l) if l greater than 1 .........
. */
L540:
	c = 0.;
	s = 1.;

	i__1 = k;
	for (i = l; i <= i__1; ++i) {
	    f = s * rv1[i];
	    rv1[i] = c * rv1[i];
	    tst2 = tst1 + abs(f);
	    if (tst2 == tst1) {
		goto L565;
	    }
	    g = w[i];
	    h = pythag_(&f, &g);
	    w[i] = h;
	    c = g / h;
	    s = -f / h;
	    if (*ip == 0) {
		goto L560;
	    }

	    i__3 = *ip;
	    for (j = 1; j <= i__3; ++j) {
		y = b[l1 + j * b_dim1];
		z = b[i + j * b_dim1];
		b[l1 + j * b_dim1] = y * c + z * s;
		b[i + j * b_dim1] = -y * s + z * c;
/* L550: */
	    }

L560:
	    ;
	}
/*     .......... test for convergence .......... */
L565:
	z = w[k];
	if (l == k) {
	    goto L650;
	}
/*     .......... shift from bottom 2 by 2 minor .......... */
	if (its == 30) {
	    goto L1000;
	}
	++its;
	x = w[l];
	y = w[k1];
	g = rv1[k1];
	h = rv1[k];
	f = ((g + z) / h * ((g - z) / y) + y / h - h / y) * .5;
	g = pythag_(&f, &c_b39);
	f = x - z / x * z + h / x * (y / (f + d_sign(&g, &f)) - h);
/*     .......... next qr transformation .......... */
	c = 1.;
	s = 1.;

	i__1 = k1;
	for (i1 = l; i1 <= i__1; ++i1) {
	    i = i1 + 1;
	    g = rv1[i];
	    y = w[i];
	    h = s * g;
	    g = c * g;
	    z = pythag_(&f, &h);
	    rv1[i1] = z;
	    c = f / z;
	    s = h / z;
	    f = x * c + g * s;
	    g = -x * s + g * c;
	    h = y * s;
	    y *= c;

	    i__3 = *n;
	    for (j = 1; j <= i__3; ++j) {
		x = a[j + i1 * a_dim1];
		z = a[j + i * a_dim1];
		a[j + i1 * a_dim1] = x * c + z * s;
		a[j + i * a_dim1] = -x * s + z * c;
/* L570: */
	    }

	    z = pythag_(&f, &h);
	    w[i1] = z;
/*     .......... rotation can be arbitrary if z is zero .........
. */
	    if (z == 0.) {
		goto L580;
	    }
	    c = f / z;
	    s = h / z;
L580:
	    f = c * g + s * y;
	    x = -s * g + c * y;
	    if (*ip == 0) {
		goto L600;
	    }

	    i__3 = *ip;
	    for (j = 1; j <= i__3; ++j) {
		y = b[i1 + j * b_dim1];
		z = b[i + j * b_dim1];
		b[i1 + j * b_dim1] = y * c + z * s;
		b[i + j * b_dim1] = -y * s + z * c;
/* L590: */
	    }

L600:
	    ;
	}

	rv1[l] = 0.;
	rv1[k] = f;
	w[k] = x;
	goto L520;
/*     .......... convergence .......... */
L650:
	if (z >= 0.) {
	    goto L700;
	}
/*     .......... w(k) is made non-negative .......... */
	w[k] = -z;

	i__1 = *n;
	for (j = 1; j <= i__1; ++j) {
/* L690: */
	    a[j + k * a_dim1] = -a[j + k * a_dim1];
	}

L700:
	;
    }

    goto L1001;
/*     .......... set error -- no convergence to a */
/*                singular value after 30 iterations .......... */
L1000:
    *ierr = k;
L1001:
    return 0;
} /* minfit_ */

