/* qzhes.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int qzhes_(nm, n, a, b, matz, z)
integer *nm, *n;
doublereal *a, *b;
logical *matz;
doublereal *z;
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, z_dim1, z_offset, i__1, i__2, 
	    i__3;
    doublereal d__1, d__2;

    /* Builtin functions */
    double sqrt(), d_sign();

    /* Local variables */
    static integer i, j, k, l;
    static doublereal r, s, t;
    static integer l1;
    static doublereal u1, u2, v1, v2;
    static integer lb, nk1, nm1, nm2;
    static doublereal rho;



/*     this subroutine is the first step of the qz algorithm */
/*     for solving generalized matrix eigenvalue problems, */
/*     siam j. numer. anal. 10, 241-256(1973) by moler and stewart. */

/*     this subroutine accepts a pair of real general matrices and */
/*     reduces one of them to upper hessenberg form and the other */
/*     to upper triangular form using orthogonal transformations. */
/*     it is usually followed by  qzit,  qzval  and, possibly,  qzvec. */

/*     on input */

/*        nm must be set to the row dimension of two-dimensional */
/*          array parameters as declared in the calling program */
/*          dimension statement. */

/*        n is the order of the matrices. */

/*        a contains a real general matrix. */

/*        b contains a real general matrix. */

/*        matz should be set to .true. if the right hand transformations 
*/
/*          are to be accumulated for later use in computing */
/*          eigenvectors, and to .false. otherwise. */

/*     on output */

/*        a has been reduced to upper hessenberg form.  the elements */
/*          below the first subdiagonal have been set to zero. */

/*        b has been reduced to upper triangular form.  the elements */
/*          below the main diagonal have been set to zero. */

/*        z contains the product of the right hand transformations if */
/*          matz has been set to .true.  otherwise, z is not referenced. 
*/

/*     questions and comments should be directed to burton s. garbow, */
/*     mathematics and computer science div, argonne national laboratory 
*/

/*     this version dated august 1983. */

/*     ------------------------------------------------------------------ 
*/

/*     .......... initialize z .......... */
    /* Parameter adjustments */
    z_dim1 = *nm;
    z_offset = z_dim1 + 1;
    z -= z_offset;
    b_dim1 = *nm;
    b_offset = b_dim1 + 1;
    b -= b_offset;
    a_dim1 = *nm;
    a_offset = a_dim1 + 1;
    a -= a_offset;

    /* Function Body */
    if (! (*matz)) {
	goto L10;
    }

    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {

	i__2 = *n;
	for (i = 1; i <= i__2; ++i) {
	    z[i + j * z_dim1] = 0.;
/* L2: */
	}

	z[j + j * z_dim1] = 1.;
/* L3: */
    }
/*     .......... reduce b to upper triangular form .......... */
L10:
    if (*n <= 1) {
	goto L170;
    }
    nm1 = *n - 1;

    i__1 = nm1;
    for (l = 1; l <= i__1; ++l) {
	l1 = l + 1;
	s = 0.;

	i__2 = *n;
	for (i = l1; i <= i__2; ++i) {
	    s += (d__1 = b[i + l * b_dim1], abs(d__1));
/* L20: */
	}

	if (s == 0.) {
	    goto L100;
	}
	s += (d__1 = b[l + l * b_dim1], abs(d__1));
	r = 0.;

	i__2 = *n;
	for (i = l; i <= i__2; ++i) {
	    b[i + l * b_dim1] /= s;
/* Computing 2nd power */
	    d__1 = b[i + l * b_dim1];
	    r += d__1 * d__1;
/* L25: */
	}

	d__1 = sqrt(r);
	r = d_sign(&d__1, &b[l + l * b_dim1]);
	b[l + l * b_dim1] += r;
	rho = r * b[l + l * b_dim1];

	i__2 = *n;
	for (j = l1; j <= i__2; ++j) {
	    t = 0.;

	    i__3 = *n;
	    for (i = l; i <= i__3; ++i) {
		t += b[i + l * b_dim1] * b[i + j * b_dim1];
/* L30: */
	    }

	    t = -t / rho;

	    i__3 = *n;
	    for (i = l; i <= i__3; ++i) {
		b[i + j * b_dim1] += t * b[i + l * b_dim1];
/* L40: */
	    }

/* L50: */
	}

	i__2 = *n;
	for (j = 1; j <= i__2; ++j) {
	    t = 0.;

	    i__3 = *n;
	    for (i = l; i <= i__3; ++i) {
		t += b[i + l * b_dim1] * a[i + j * a_dim1];
/* L60: */
	    }

	    t = -t / rho;

	    i__3 = *n;
	    for (i = l; i <= i__3; ++i) {
		a[i + j * a_dim1] += t * b[i + l * b_dim1];
/* L70: */
	    }

/* L80: */
	}

	b[l + l * b_dim1] = -s * r;

	i__2 = *n;
	for (i = l1; i <= i__2; ++i) {
	    b[i + l * b_dim1] = 0.;
/* L90: */
	}

L100:
	;
    }
/*     .......... reduce a to upper hessenberg form, while */
/*                keeping b triangular .......... */
    if (*n == 2) {
	goto L170;
    }
    nm2 = *n - 2;

    i__1 = nm2;
    for (k = 1; k <= i__1; ++k) {
	nk1 = nm1 - k;
/*     .......... for l=n-1 step -1 until k+1 do -- .......... */
	i__2 = nk1;
	for (lb = 1; lb <= i__2; ++lb) {
	    l = *n - lb;
	    l1 = l + 1;
/*     .......... zero a(l+1,k) .......... */
	    s = (d__1 = a[l + k * a_dim1], abs(d__1)) + (d__2 = a[l1 + k * 
		    a_dim1], abs(d__2));
	    if (s == 0.) {
		goto L150;
	    }
	    u1 = a[l + k * a_dim1] / s;
	    u2 = a[l1 + k * a_dim1] / s;
	    d__1 = sqrt(u1 * u1 + u2 * u2);
	    r = d_sign(&d__1, &u1);
	    v1 = -(u1 + r) / r;
	    v2 = -u2 / r;
	    u2 = v2 / v1;

	    i__3 = *n;
	    for (j = k; j <= i__3; ++j) {
		t = a[l + j * a_dim1] + u2 * a[l1 + j * a_dim1];
		a[l + j * a_dim1] += t * v1;
		a[l1 + j * a_dim1] += t * v2;
/* L110: */
	    }

	    a[l1 + k * a_dim1] = 0.;

	    i__3 = *n;
	    for (j = l; j <= i__3; ++j) {
		t = b[l + j * b_dim1] + u2 * b[l1 + j * b_dim1];
		b[l + j * b_dim1] += t * v1;
		b[l1 + j * b_dim1] += t * v2;
/* L120: */
	    }
/*     .......... zero b(l+1,l) .......... */
	    s = (d__1 = b[l1 + l1 * b_dim1], abs(d__1)) + (d__2 = b[l1 + l * 
		    b_dim1], abs(d__2));
	    if (s == 0.) {
		goto L150;
	    }
	    u1 = b[l1 + l1 * b_dim1] / s;
	    u2 = b[l1 + l * b_dim1] / s;
	    d__1 = sqrt(u1 * u1 + u2 * u2);
	    r = d_sign(&d__1, &u1);
	    v1 = -(u1 + r) / r;
	    v2 = -u2 / r;
	    u2 = v2 / v1;

	    i__3 = l1;
	    for (i = 1; i <= i__3; ++i) {
		t = b[i + l1 * b_dim1] + u2 * b[i + l * b_dim1];
		b[i + l1 * b_dim1] += t * v1;
		b[i + l * b_dim1] += t * v2;
/* L130: */
	    }

	    b[l1 + l * b_dim1] = 0.;

	    i__3 = *n;
	    for (i = 1; i <= i__3; ++i) {
		t = a[i + l1 * a_dim1] + u2 * a[i + l * a_dim1];
		a[i + l1 * a_dim1] += t * v1;
		a[i + l * a_dim1] += t * v2;
/* L140: */
	    }

	    if (! (*matz)) {
		goto L150;
	    }

	    i__3 = *n;
	    for (i = 1; i <= i__3; ++i) {
		t = z[i + l1 * z_dim1] + u2 * z[i + l * z_dim1];
		z[i + l1 * z_dim1] += t * v1;
		z[i + l * z_dim1] += t * v2;
/* L145: */
	    }

L150:
	    ;
	}

/* L160: */
    }

L170:
    return 0;
} /* qzhes_ */

