/* tsturm.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static doublereal c_b26 = 1.;

/* Subroutine */ int tsturm_(nm, n, eps1, d, e, e2, lb, ub, mm, m, w, z, ierr,
	 rv1, rv2, rv3, rv4, rv5, rv6)
integer *nm, *n;
doublereal *eps1, *d, *e, *e2, *lb, *ub;
integer *mm, *m;
doublereal *w, *z;
integer *ierr;
doublereal *rv1, *rv2, *rv3, *rv4, *rv5, *rv6;
{
    /* System generated locals */
    integer z_dim1, z_offset, i__1, i__2, i__3;
    doublereal d__1, d__2, d__3, d__4;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static doublereal norm;
    static integer i, j, k, p, q, r, s;
    static doublereal u, v;
    static integer group, m1, m2;
    static doublereal t1, t2, x0, x1;
    static integer ii, jj, ip;
    static doublereal uk, xu;
    extern doublereal pythag_(), epslon_();
    static integer isturm, its;
    static doublereal eps2, eps3, eps4, tst1, tst2;



/*     this subroutine is a translation of the algol procedure tristurm */
/*     by peters and wilkinson. */
/*     handbook for auto. comp., vol.ii-linear algebra, 418-439(1971). */

/*     this subroutine finds those eigenvalues of a tridiagonal */
/*     symmetric matrix which lie in a specified interval and their */
/*     associated eigenvectors, using bisection and inverse iteration. */

/*     on input */

/*        nm must be set to the row dimension of two-dimensional */
/*          array parameters as declared in the calling program */
/*          dimension statement. */

/*        n is the order of the matrix. */

/*        eps1 is an absolute error tolerance for the computed */
/*          eigenvalues.  it should be chosen commensurate with */
/*          relative perturbations in the matrix elements of the */
/*          order of the relative machine precision.  if the */
/*          input eps1 is non-positive, it is reset for each */
/*          submatrix to a default value, namely, minus the */
/*          product of the relative machine precision and the */
/*          1-norm of the submatrix. */

/*        d contains the diagonal elements of the input matrix. */

/*        e contains the subdiagonal elements of the input matrix */
/*          in its last n-1 positions.  e(1) is arbitrary. */

/*        e2 contains the squares of the corresponding elements of e. */
/*          e2(1) is arbitrary. */

/*        lb and ub define the interval to be searched for eigenvalues. */
/*          if lb is not less than ub, no eigenvalues will be found. */

/*        mm should be set to an upper bound for the number of */
/*          eigenvalues in the interval.  warning. if more than */
/*          mm eigenvalues are determined to lie in the interval, */
/*          an error return is made with no values or vectors found. */

/*     on output */

/*        eps1 is unaltered unless it has been reset to its */
/*          (last) default value. */

/*        d and e are unaltered. */

/*        elements of e2, corresponding to elements of e regarded */
/*          as negligible, have been replaced by zero causing the */
/*          matrix to split into a direct sum of submatrices. */
/*          e2(1) is also set to zero. */

/*        m is the number of eigenvalues determined to lie in (lb,ub). */

/*        w contains the m eigenvalues in ascending order if the matrix */
/*          does not split.  if the matrix splits, the eigenvalues are */
/*          in ascending order for each submatrix.  if a vector error */
/*          exit is made, w contains those values already found. */

/*        z contains the associated set of orthonormal eigenvectors. */
/*          if an error exit is made, z contains those vectors */
/*          already found. */

/*        ierr is set to */
/*          zero       for normal return, */
/*          3*n+1      if m exceeds mm. */
/*          4*n+r      if the eigenvector corresponding to the r-th */
/*                     eigenvalue fails to converge in 5 iterations. */

/*        rv1, rv2, rv3, rv4, rv5, and rv6 are temporary storage arrays. 
*/

/*     the algol procedure sturmcnt contained in tristurm */
/*     appears in tsturm in-line. */

/*     calls pythag for  dsqrt(a*a + b*b) . */

/*     questions and comments should be directed to burton s. garbow, */
/*     mathematics and computer science div, argonne national laboratory 
*/

/*     this version dated august 1983. */

/*     ------------------------------------------------------------------ 
*/

    /* Parameter adjustments */
    --rv6;
    --rv5;
    --rv4;
    --rv3;
    --rv2;
    --rv1;
    --e2;
    --e;
    --d;
    z_dim1 = *nm;
    z_offset = z_dim1 + 1;
    z -= z_offset;
    --w;

    /* Function Body */
    *ierr = 0;
    t1 = *lb;
    t2 = *ub;
/*     .......... look for small sub-diagonal entries .......... */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	if (i == 1) {
	    goto L20;
	}
	tst1 = (d__1 = d[i], abs(d__1)) + (d__2 = d[i - 1], abs(d__2));
	tst2 = tst1 + (d__1 = e[i], abs(d__1));
	if (tst2 > tst1) {
	    goto L40;
	}
L20:
	e2[i] = 0.;
L40:
	;
    }
/*     .......... determine the number of eigenvalues */
/*                in the interval .......... */
    p = 1;
    q = *n;
    x1 = *ub;
    isturm = 1;
    goto L320;
L60:
    *m = s;
    x1 = *lb;
    isturm = 2;
    goto L320;
L80:
    *m -= s;
    if (*m > *mm) {
	goto L980;
    }
    q = 0;
    r = 0;
/*     .......... establish and process next submatrix, refining */
/*                interval by the gerschgorin bounds .......... */
L100:
    if (r == *m) {
	goto L1001;
    }
    p = q + 1;
    xu = d[p];
    x0 = d[p];
    u = 0.;

    i__1 = *n;
    for (q = p; q <= i__1; ++q) {
	x1 = u;
	u = 0.;
	v = 0.;
	if (q == *n) {
	    goto L110;
	}
	u = (d__1 = e[q + 1], abs(d__1));
	v = e2[q + 1];
L110:
/* Computing MIN */
	d__1 = d[q] - (x1 + u);
	xu = min(d__1,xu);
/* Computing MAX */
	d__1 = d[q] + (x1 + u);
	x0 = max(d__1,x0);
	if (v == 0.) {
	    goto L140;
	}
/* L120: */
    }

L140:
/* Computing MAX */
    d__2 = abs(xu), d__3 = abs(x0);
    d__1 = max(d__2,d__3);
    x1 = epslon_(&d__1);
    if (*eps1 <= 0.) {
	*eps1 = -x1;
    }
    if (p != q) {
	goto L180;
    }
/*     .......... check for isolated root within interval .......... */
    if (t1 > d[p] || d[p] >= t2) {
	goto L940;
    }
    ++r;

    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
/* L160: */
	z[i + r * z_dim1] = 0.;
    }

    w[r] = d[p];
    z[p + r * z_dim1] = 1.;
    goto L940;
L180:
    u = (doublereal) (q - p + 1);
    x1 = u * x1;
/* Computing MAX */
    d__1 = t1, d__2 = xu - x1;
    *lb = max(d__1,d__2);
/* Computing MIN */
    d__1 = t2, d__2 = x0 + x1;
    *ub = min(d__1,d__2);
    x1 = *lb;
    isturm = 3;
    goto L320;
L200:
    m1 = s + 1;
    x1 = *ub;
    isturm = 4;
    goto L320;
L220:
    m2 = s;
    if (m1 > m2) {
	goto L940;
    }
/*     .......... find roots by bisection .......... */
    x0 = *ub;
    isturm = 5;

    i__1 = m2;
    for (i = m1; i <= i__1; ++i) {
	rv5[i] = *ub;
	rv4[i] = *lb;
/* L240: */
    }
/*     .......... loop for k-th eigenvalue */
/*                for k=m2 step -1 until m1 do -- */
/*                (-do- not used to legalize -computed go to-) .......... 
*/
    k = m2;
L250:
    xu = *lb;
/*     .......... for i=k step -1 until m1 do -- .......... */
    i__1 = k;
    for (ii = m1; ii <= i__1; ++ii) {
	i = m1 + k - ii;
	if (xu >= rv4[i]) {
	    goto L260;
	}
	xu = rv4[i];
	goto L280;
L260:
	;
    }

L280:
    if (x0 > rv5[k]) {
	x0 = rv5[k];
    }
/*     .......... next bisection step .......... */
L300:
    x1 = (xu + x0) * .5;
    if (x0 - xu <= abs(*eps1)) {
	goto L420;
    }
    tst1 = (abs(xu) + abs(x0)) * 2.;
    tst2 = tst1 + (x0 - xu);
    if (tst2 == tst1) {
	goto L420;
    }
/*     .......... in-line procedure for sturm sequence .......... */
L320:
    s = p - 1;
    u = 1.;

    i__1 = q;
    for (i = p; i <= i__1; ++i) {
	if (u != 0.) {
	    goto L325;
	}
	v = (d__1 = e[i], abs(d__1)) / epslon_(&c_b26);
	if (e2[i] == 0.) {
	    v = 0.;
	}
	goto L330;
L325:
	v = e2[i] / u;
L330:
	u = d[i] - x1 - v;
	if (u < 0.) {
	    ++s;
	}
/* L340: */
    }

    switch ((int)isturm) {
	case 1:  goto L60;
	case 2:  goto L80;
	case 3:  goto L200;
	case 4:  goto L220;
	case 5:  goto L360;
    }
/*     .......... refine intervals .......... */
L360:
    if (s >= k) {
	goto L400;
    }
    xu = x1;
    if (s >= m1) {
	goto L380;
    }
    rv4[m1] = x1;
    goto L300;
L380:
    rv4[s + 1] = x1;
    if (rv5[s] > x1) {
	rv5[s] = x1;
    }
    goto L300;
L400:
    x0 = x1;
    goto L300;
/*     .......... k-th eigenvalue found .......... */
L420:
    rv5[k] = x1;
    --k;
    if (k >= m1) {
	goto L250;
    }
/*     .......... find vectors by inverse iteration .......... */
    norm = (d__1 = d[p], abs(d__1));
    ip = p + 1;

    i__1 = q;
    for (i = ip; i <= i__1; ++i) {
/* L500: */
/* Computing MAX */
	d__3 = norm, d__4 = (d__1 = d[i], abs(d__1)) + (d__2 = e[i], abs(d__2)
		);
	norm = max(d__3,d__4);
    }
/*     .......... eps2 is the criterion for grouping, */
/*                eps3 replaces zero pivots and equal */
/*                roots are modified by eps3, */
/*                eps4 is taken very small to avoid overflow .......... */
    eps2 = norm * .001;
    eps3 = epslon_(&norm);
    uk = (doublereal) (q - p + 1);
    eps4 = uk * eps3;
    uk = eps4 / sqrt(uk);
    group = 0;
    s = p;

    i__1 = m2;
    for (k = m1; k <= i__1; ++k) {
	++r;
	its = 1;
	w[r] = rv5[k];
	x1 = rv5[k];
/*     .......... look for close or coincident roots .......... */
	if (k == m1) {
	    goto L520;
	}
	if (x1 - x0 >= eps2) {
	    group = -1;
	}
	++group;
	if (x1 <= x0) {
	    x1 = x0 + eps3;
	}
/*     .......... elimination with interchanges and */
/*                initialization of vector .......... */
L520:
	v = 0.;

	i__2 = q;
	for (i = p; i <= i__2; ++i) {
	    rv6[i] = uk;
	    if (i == p) {
		goto L560;
	    }
	    if ((d__1 = e[i], abs(d__1)) < abs(u)) {
		goto L540;
	    }
	    xu = u / e[i];
	    rv4[i] = xu;
	    rv1[i - 1] = e[i];
	    rv2[i - 1] = d[i] - x1;
	    rv3[i - 1] = 0.;
	    if (i != q) {
		rv3[i - 1] = e[i + 1];
	    }
	    u = v - xu * rv2[i - 1];
	    v = -xu * rv3[i - 1];
	    goto L580;
L540:
	    xu = e[i] / u;
	    rv4[i] = xu;
	    rv1[i - 1] = u;
	    rv2[i - 1] = v;
	    rv3[i - 1] = 0.;
L560:
	    u = d[i] - x1 - xu * v;
	    if (i != q) {
		v = e[i + 1];
	    }
L580:
	    ;
	}

	if (u == 0.) {
	    u = eps3;
	}
	rv1[q] = u;
	rv2[q] = 0.;
	rv3[q] = 0.;
/*     .......... back substitution */
/*                for i=q step -1 until p do -- .......... */
L600:
	i__2 = q;
	for (ii = p; ii <= i__2; ++ii) {
	    i = p + q - ii;
	    rv6[i] = (rv6[i] - u * rv2[i] - v * rv3[i]) / rv1[i];
	    v = u;
	    u = rv6[i];
/* L620: */
	}
/*     .......... orthogonalize with respect to previous */
/*                members of group .......... */
	if (group == 0) {
	    goto L700;
	}

	i__2 = group;
	for (jj = 1; jj <= i__2; ++jj) {
	    j = r - group - 1 + jj;
	    xu = 0.;

	    i__3 = q;
	    for (i = p; i <= i__3; ++i) {
/* L640: */
		xu += rv6[i] * z[i + j * z_dim1];
	    }

	    i__3 = q;
	    for (i = p; i <= i__3; ++i) {
/* L660: */
		rv6[i] -= xu * z[i + j * z_dim1];
	    }

/* L680: */
	}

L700:
	norm = 0.;

	i__2 = q;
	for (i = p; i <= i__2; ++i) {
/* L720: */
	    norm += (d__1 = rv6[i], abs(d__1));
	}

	if (norm >= 1.) {
	    goto L840;
	}
/*     .......... forward substitution .......... */
	if (its == 5) {
	    goto L960;
	}
	if (norm != 0.) {
	    goto L740;
	}
	rv6[s] = eps4;
	++s;
	if (s > q) {
	    s = p;
	}
	goto L780;
L740:
	xu = eps4 / norm;

	i__2 = q;
	for (i = p; i <= i__2; ++i) {
/* L760: */
	    rv6[i] *= xu;
	}
/*     .......... elimination operations on next vector */
/*                iterate .......... */
L780:
	i__2 = q;
	for (i = ip; i <= i__2; ++i) {
	    u = rv6[i];
/*     .......... if rv1(i-1) .eq. e(i), a row interchange */
/*                was performed earlier in the */
/*                triangularization process .......... */
	    if (rv1[i - 1] != e[i]) {
		goto L800;
	    }
	    u = rv6[i - 1];
	    rv6[i - 1] = rv6[i];
L800:
	    rv6[i] = u - rv4[i] * rv6[i - 1];
/* L820: */
	}

	++its;
	goto L600;
/*     .......... normalize so that sum of squares is */
/*                1 and expand to full order .......... */
L840:
	u = 0.;

	i__2 = q;
	for (i = p; i <= i__2; ++i) {
/* L860: */
	    u = pythag_(&u, &rv6[i]);
	}

	xu = 1. / u;

	i__2 = *n;
	for (i = 1; i <= i__2; ++i) {
/* L880: */
	    z[i + r * z_dim1] = 0.;
	}

	i__2 = q;
	for (i = p; i <= i__2; ++i) {
/* L900: */
	    z[i + r * z_dim1] = rv6[i] * xu;
	}

	x0 = x1;
/* L920: */
    }

L940:
    if (q < *n) {
	goto L100;
    }
    goto L1001;
/*     .......... set error -- non-converged eigenvector .......... */
L960:
    *ierr = (*n << 2) + r;
    goto L1001;
/*     .......... set error -- underestimate of number of */
/*                eigenvalues in interval .......... */
L980:
    *ierr = *n * 3 + 1;
L1001:
    *lb = t1;
    *ub = t2;
    return 0;
} /* tsturm_ */

