/* tqlrat.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static doublereal c_b12 = 1.;

/* *** for old version, "send otqlrat from eispack" */
/* * From dana!moler Tue, 1 Sep 87 10:15:40 PDT */
/* * New TQLRAT */
/* Subroutine */ int tqlrat_(n, d, e2, ierr)
integer *n;
doublereal *d, *e2;
integer *ierr;
{
    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1, d__2;

    /* Builtin functions */
    double sqrt(), d_sign();

    /* Local variables */
    static doublereal b, c, f, g, h;
    static integer i, j, l, m;
    static doublereal p, r, s, t;
    static integer l1, ii;
    extern doublereal pythag_(), epslon_();
    static integer mml;



/*     This subroutine is a translation of the Algol procedure tqlrat, */
/*     Algorithm 464, Comm. ACM 16, 689(1973) by Reinsch. */

/*     This subroutine finds the eigenvalues of a symmetric */
/*     tridiagonal matrix by the rational QL method. */

/*     On input */

/*        N is the order of the matrix. */

/*        D contains the diagonal elements of the input matrix. */

/*        E2 contains the squares of the subdiagonal elements of the */
/*          input matrix in its last N-1 positions.  E2(1) is arbitrary. 
*/

/*      On output */

/*        D contains the eigenvalues in ascending order.  If an */
/*          error exit is made, the eigenvalues are correct and */
/*          ordered for indices 1,2,...IERR-1, but may not be */
/*          the smallest eigenvalues. */

/*        E2 has been destroyed. */

/*        IERR is set to */
/*          zero       for normal return, */
/*          J          if the J-th eigenvalue has not been */
/*                     determined after 30 iterations. */

/*     Calls PYTHAG for  DSQRT(A*A + B*B) . */

/*     Questions and comments should be directed to Burton S. Garbow, */
/*     Mathematics and Computer Science Div, Argonne National Laboratory 
*/

/*     This version dated August 1987. */
/*     Modified by C. Moler to fix underflow/overflow difficulties, */
/*     especially on the VAX and other machines where epslon(1.0d0)**2 */
/*     nearly underflows.  See the loop involving statement 102 and */
/*     the two statements just before statement 200. */

/*     ------------------------------------------------------------------ 
*/

    /* Parameter adjustments */
    --e2;
    --d;

    /* Function Body */
    *ierr = 0;
    if (*n == 1) {
	goto L1001;
    }

    i__1 = *n;
    for (i = 2; i <= i__1; ++i) {
/* L100: */
	e2[i - 1] = e2[i];
    }

    f = 0.;
    t = 0.;
    e2[*n] = 0.;

    i__1 = *n;
    for (l = 1; l <= i__1; ++l) {
	j = 0;
	h = (d__1 = d[l], abs(d__1)) + sqrt(e2[l]);
	if (t > h) {
	    goto L105;
	}
	t = h;
	b = epslon_(&t);
	c = b * b;
	if (c != 0.) {
	    goto L105;
	}
/*        Spliting tolerance underflowed.  Look for larger value. */
	i__2 = *n;
	for (i = l; i <= i__2; ++i) {
	    h = (d__1 = d[i], abs(d__1)) + sqrt(e2[i]);
	    if (h > t) {
		t = h;
	    }
/* L102: */
	}
	b = epslon_(&t);
	c = b * b;
/*     .......... LOOK FOR SMALL SQUARED SUB-DIAGONAL ELEMENT ........
.. */
L105:
	i__2 = *n;
	for (m = l; m <= i__2; ++m) {
	    if (e2[m] <= c) {
		goto L120;
	    }
/*     .......... E2(N) IS ALWAYS ZERO, SO THERE IS NO EXIT */
/*                THROUGH THE BOTTOM OF THE LOOP .......... */
/* L110: */
	}

L120:
	if (m == l) {
	    goto L210;
	}
L130:
	if (j == 30) {
	    goto L1000;
	}
	++j;
/*     .......... FORM SHIFT .......... */
	l1 = l + 1;
	s = sqrt(e2[l]);
	g = d[l];
	p = (d[l1] - g) / (s * 2.);
	r = pythag_(&p, &c_b12);
	d[l] = s / (p + d_sign(&r, &p));
	h = g - d[l];

	i__2 = *n;
	for (i = l1; i <= i__2; ++i) {
/* L140: */
	    d[i] -= h;
	}

	f += h;
/*     .......... RATIONAL QL TRANSFORMATION .......... */
	g = d[m];
	if (g == 0.) {
	    g = b;
	}
	h = g;
	s = 0.;
	mml = m - l;
/*     .......... FOR I=M-1 STEP -1 UNTIL L DO -- .......... */
	i__2 = mml;
	for (ii = 1; ii <= i__2; ++ii) {
	    i = m - ii;
	    p = g * h;
	    r = p + e2[i];
	    e2[i + 1] = s * r;
	    s = e2[i] / r;
	    d[i + 1] = h + s * (h + d[i]);
	    g = d[i] - e2[i] / g;
/*           Avoid division by zero on next pass */
	    if (g == 0.) {
		g = epslon_(&d[i]);
	    }
	    h = g * (p / r);
/* L200: */
	}

	e2[l] = s * g;
	d[l] = h;
/*     .......... GUARD AGAINST UNDERFLOW IN CONVERGENCE TEST ........
.. */
	if (h == 0.) {
	    goto L210;
	}
	if ((d__1 = e2[l], abs(d__1)) <= (d__2 = c / h, abs(d__2))) {
	    goto L210;
	}
	e2[l] = h * e2[l];
	if (e2[l] != 0.) {
	    goto L130;
	}
L210:
	p = d[l] + f;
/*     .......... ORDER EIGENVALUES .......... */
	if (l == 1) {
	    goto L250;
	}
/*     .......... FOR I=L STEP -1 UNTIL 2 DO -- .......... */
	i__2 = l;
	for (ii = 2; ii <= i__2; ++ii) {
	    i = l + 2 - ii;
	    if (p >= d[i - 1]) {
		goto L270;
	    }
	    d[i] = d[i - 1];
/* L230: */
	}

L250:
	i = 1;
L270:
	d[i] = p;
/* L290: */
    }

    goto L1001;
/*     .......... SET ERROR -- NO CONVERGENCE TO AN */
/*                EIGENVALUE AFTER 30 ITERATIONS .......... */
L1000:
    *ierr = l;
L1001:
    return 0;
} /* tqlrat_ */

