proc (gamma, mu, sigma) = momentgp (x, k)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      pickandsgp mlegp mlegp0 hillgp1 dpgp momentgpdiag
; -----------------------------------------------------------------
;   Macro         momentgp
; -----------------------------------------------------------------
;   Description   Moment estimator for GP model.
; -----------------------------------------------------------------
;   Usage         {gamma, mu, sigma} = momentgp (x, k)
;   Input
;     Parameter   x
;     Definition      vector
;     Parameter   k
;     Definition      integer, number of upper extremes
;   Output
;     Parameter   gamma
;     Definition      scalar, estimated shape parameter
;     Parameter   mu
;     Definition      scalar, estimated location parameter
;     Parameter   sigma
;     Definition      scalar, estimated scale parameter	    
; -----------------------------------------------------------------
;   Example   library("finance")
;	      x=gpdata(1,100)
;             m=momentgp(x,50)
;             m
; -----------------------------------------------------------------
;   Result    Contents of m.gamma
;             [1,]   1.201
;	      Contents of m.mu
;	      [1,]  0.12913
;             Contents of m.sigma
;             [1,]  0.85639 
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  n0 = rows (x)
  x = sort (paf (x, x > 0))
  n = rows (x)
  error (n < 3, "Data set must have at least 2 elements")
  if (k > n)
    warning (k > n, "Number of exceedances is too large")
    k = n
  endif
  if (k < 3)
    warning (k < 3, "Number of exceedances is too small")
    k = 3
  endif
  help = log (x [n - k + 2 : n] / x [n - k + 1])
  l1 = mean (help)
  l2 = mean (help^2)
  gamma = l1 + 1 - 1  / (2 * (1 - l1*l1/l2))
  mu = x [n - k + 1]
  sigma = gpsigmaest (gamma, x [n - k + 1:n])
  r = fittail (gam