; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         clust07
; ----------------------------------------------------------------------------
; Description   computes the dendrogram with the centroid linkage method
; ----------------------------------------------------------------------------
  x=#(5, 2, (-2), (-3), (-2), (-2), 1, 1)~ #( (-3), (-4), (-1), 0, (-2), 4, 2, 4); creates 8 pairs of data
  n=rows(x)                       ; rows of data
  xs=string("%1.0f", 1:n)         ; adds labels
  setsize(500, 500)
  dd1=createdisplay(1,1)
  setmaskp(x, 0, 0, 0)
  setmaskt(x, string("%.0f", 1:rows(x)), 0, 0, 16)
  setmaskl(x, 1~2~7~8~6~0~7~3~5~0~3~4, 0, 1, 1)
  show(dd1, 1, 1, x)                   ; shows data
  setgopt(dd1, 1, 1, "xlabel", "first coordinate", "ylabel", "second coordinate")
  setgopt(dd1, 1, 1, "title", " 8 points", "xoffset", 7|7, "yoffset", 7|7)

  d=distance(x, "euclid")         ; Euclidean distance
  d.*d                            ; squared distance matrix
  t=agglom(d.*d, "CENTROID", 5)     ; here centroid method
  g=tree(t.g, 0, "CENTER")
  g=g.points
  l = 5.*(1:rows(g)/5) + (0:4)' - 4
  setmaskl (g, l, 0, 1, 1)
  setmaskp (g, 0, 0, 0)

  tg=paf(t.g[,2], t.g[,2]!=0)
  numbers=(0:(rows(x)-1))
  numbers=numbers~((-1)*matrix(rows(x)))
  setmaskp(numbers, 0, 0, 0)
  setmaskt(numbers, string("%.0f", tg), 0, 0, 14)
  dd2=createdisplay(1,1)
  show (dd2, 1, 1, g, numbers)
  setgopt(dd2, 1, 1, "xlabel","Centroid Dendrogramm" , "ylabel", "Squared Euclidian Distance" )
  setgopt(dd2, 1, 1, "title", " 8 points", "xoffset", 7|7, "yoffset", 7|7)
