; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         clust17
; ----------------------------------------------------------------------------
; Description  compares the Ward and Fuzzy-C-Means method for the Swiss 
;              Banknote data with three clusters 
; ----------------------------------------------------------------------------

proc()=main(x,x46)
  
; compute the euclidean distance between banknotes
  i=0
  d=0.*matrix(rows(x),rows(x))
  while (i.<cols(x))
    i = i+1
    d = d+(x[,i] - x[,i]')^2
  endo
  d = sqrt(d) 
; use the WARD method to cluster the data
  t = agglom (d, "WARD", 3)
  
  d=createdisplay(2,1)
  setmaskp(x46,t.p,t.p+1,7)
  show(d,1,1,x46)
  title="Ward Method for Bank Notes Data with three clusters"
  setgopt(d,1,1,"title", title)  
  
endp
;

library("xclust")
x=read("bank2.dat")
x4=x[,4]
x6=x[,6]
x46=x4~x6
main(x,x46)     ; apply ward method

c=3            ; initialize for fuzzy c-means clustering
m=1.25
e=0.001
alpha=0.5
fcm=xcfcme(x,c,m,e,alpha)          ; apply fuzzy-c-means clustering

setmaskp(x46,fcm.clus,fcm.clus+1,7)
show(d,2,1,x46)
title="Fuzzy-c-means for Bank Notes Data with three clusters"
setgopt(d,2,1,"title", title)  