; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      eivknownatt
; ----------------------------------------------------------------------------
; Macro         eiv01
; ----------------------------------------------------------------------------
; Description   estimates the parameters of eiv model for simulated data 
;		swith known reliability ratio
; ----------------------------------------------------------------------------
library("eiv")
n = 100
randomize(n)
x=0.9*normal(n)
w=x+0.9*normal(n)
y=0.9+0.8*x+0.01*normal(n)
kww =0.5
gest=eivknownatt(w,y,kww)
gest.mux        ; the estimate of the mean of x
gest.beta1      ; the estimate of b (true value is 0.8)
gest.beta0      ; the estimate of a (true value is 0.9)
gest.sigmax     ; the estimate of the variance of x
gest.sigmau     ; the estimate of the variance of u
gest.sigmae     ; the estimate of the variance of e
gest.varbeta1   ; the estimate of the variance of the estimate of beta1
gest.varbeta0   ; the estimate of the variance of the estimate of beta0
