; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         flts06
; ----------------------------------------------------------------------------
; Description   Confidence intervals for NAR(1) model for lynx data
; ----------------------------------------------------------------------------
    library("smoother")
    library("plot")
    library("times")
    setsize(640,480)
; 	generate exponential AR(1) process 
    phi1		= 0.3
    phi2		= 2.2
    g			= 0.1
    randomize(0)
    x			= genexpar(1,g,phi1,phi1+phi2,normal(150))  
;  	data preparation
    xrows 		= rows(x)
    lag1  		= x[1:xrows-1]             ; vector of first lag
    y     		= x[2:xrows]               ; vector of dep. var.
    data  		= lag1~y 
;	true function
    f			= sort(lag1~(phi1*lag1 + phi2*lag1.*exp(-g*lag1^2)),1)
;     	estimation
    {hcrit,crit}	= regxbwsel(data)
    {mh, clo, cup} 	= regxci(data,hcrit)

    f			= setmask(f,"line","solid","red") 
    data 		= setmask(data,"cross")
    mh			= setmask(mh,"line","dashed","blue")
    clo			= setmask(clo,"line","blue","thin","dotted") 
    cup			= setmask(cup,"line","blue","thin","dotted")
    plot(data,f,mh,clo,cup)
    setgopt(plotdisplay,1,1,"title","Confidence intervals of estimated NAR(1) mean function","xlabel","First Lag","ylabel","Y")
