; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         flts07 
; ----------------------------------------------------------------------------
; Description   Local quadratic estimation of first and second derivatives
;               for NAR(1) model
; ----------------------------------------------------------------------------
    library("smoother")
    library("plot")
		library("times")
    setsize(640,480)
; 					generate exponential AR(1) process 
    phi1	= 0.3
    phi2	= 2.2
    g		= 0.1
    randomize(0)
    x		= genexpar(1,g,phi1,phi1+phi2,normal(150))  

;                       data preparation
    xrows 	= rows(x)
    lag1  	= x[1:xrows-1]             ; vector of first lag
    y     	= x[2:xrows]               ; vector of dep. var.
    data  	= lag1~y
    ffder	= sort(lag1~(phi1 + exp(-g*lag1^2).*phi2.*(1-2.*g.*lag1^2)),1)
    fsder	= sort(lag1~(exp(-g*lag1^2).*(-2*g.*lag1)*phi2.*(3-2.*g.*lag1^2)),1)	  

;                       estimate first derivative
    ffder	= setmask(ffder,"line","solid","red") 
    mhfder	= lpderxest(data)
    mhfder	= setmask(mhfder, "line","dashed","blue")
    plotder 	= createdisplay(1,1)
    show(plotder,1,1,ffder,mhfder)

    setgopt(plotder,1,1,"title","Estimated first derivative of mean function","xlabel","First lag","ylabel","First derivative")

;                       estimate second derivative
    fsder	= setmask(fsder,"line","solid","red") 
    hrot	= 2*lpderrot(data,2)
    mhsder	= lpderxest(data,hrot,2)
    mhsder	= setmask(mhsder, "line","dashed","blue")
    plot(fsder,mhsder)
    setgopt(plotdisplay,1,1,"title","Estimated second derivative of mean function","xlabel","First lag","ylabel","Second derivative")
