; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      tp/cafpe/cafpe
; ----------------------------------------------------------------------------
; Macro         flts12
; ----------------------------------------------------------------------------
; Description   selects lags for conditional mean of nonlinear AR process 
;               for exchange rate returns using CAFPE criterion
; ----------------------------------------------------------------------------
  pathcafpe	= "tp/cafpe/"	; path for CAFPE quantlets

  library("xplore")
  library("times")
  func(pathcafpe + "cafpeload")	;load required XploRe files of CAFPE
  cafpeload(pathcafpe)    	
; 	set output format
  setenv("outheadline","")     	; no header for each output file
  setenv("outlineno","")   	; no numbering of output lines
; 	load data
  y		= read("dmus58-300.dat")  ; name of data file
  truedat    	= "";		; name of potential data file
  xdataln 	= "no";		; don't take logarithms
  xdatadif 	= "yes";	; take first differences
  xdatastand 	= "no";		; don't standardize data
  lagmax 	= 6		; the largest lag considered is 6
  searchmethod 	= "full"	; consider all possible lag combinations 
  dmax 		= 6		; consider at most 6 lags

; 	conduct lag selection
  { crmin,crpro } = cafpe(y,truedat,xdataln,xdatadif,xdatastand,lagmax,searchmethod,dmax)
  "selected lag vector,               estimated CAFPE "
  crmin[,1:dmax+1]
  "number of lags, chosen lag vector,        estimated CAFPE, plug-in bandwidth"
  (0:dmax)~crpro[,1:dmax|(dmax+4)|(dmax+1)]
