; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      gplmcore
; ----------------------------------------------------------------------------
; Macro         gplm04
; ----------------------------------------------------------------------------
; Description   GPLM estimation for the Credit data with gplmcore.
; ----------------------------------------------------------------------------
  file=read("kredit")  
  file=paf(file,(file[,5]>=1)&&(file[,5]<=3)) 
                                     ; purpose=car/furniture
  y=file[,1]
  x=(file[,4]>2)                     ; previous loans o.k.
  x=x~(file[,8]>2)                   ; employed (>=1 year)
  x=x~(file[,3])                     ; duration of loan
  t=(file[,6])                       ; amount of loan
  t=t~(file[,14])                    ; age of client
  xvars="previous"|"employed"|"duration"
  tvars="amount"|"age"
;
  t=log(t)               ; logs of amount and age
  trange=max(t)-min(t)
  t=(t-min(t))./trange   ; transformation to [0,1]
;
  library("gplm")
;
  n=rows(x)
  p=cols(x)
  q=cols(t)
;
  tmp=sort(t~y~x)      ; sort data by first column of t
  t=tmp[,(1:q)]
  y=tmp[,(q+1)]
  x=tmp[,(q+2):cols(tmp)]
; 
  shf   =  1      ; show iteration (1="true")
  miter = 10      ; maximal number of iterations
  cnv   =  0.0001 ; convergence criterion
  fscor =  0      ; Fisher scoring (1="true")
  pow   =  0      ; power for power link (if useful)
  nbk   =  1      ; k for neg. binomial (if useful)
  meth  =  0      ; algorithm ( -1 = backfitting,
                  ;              0 = Speckman
                  ;              1 = profile likelihood )
  ctrl=shf|miter|cnv|fscor|pow|nbk|meth
;
  wx    = 1       ; prior or frequency weights 
  wt    = 1       ; trimming weights for estiamtion of b
  wtc   = 1       ; weights for the convergence criterion
  off   = 0       ; offset
;
  l=glmcore("bilo",x~t~matrix(n),y,wx,off,ctrl[1:6])
  b0=l.b[1:p]
  m0=l.b[p+q+1]+t*l.b[(p+1):(p+q)]
;
  h=0.4|0.4
  g=gplmcore("bilo",x,t,y,h,wx,wt,wtc,b0,m0,off,ctrl)
  g.b
