; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      hazregll
; ----------------------------------------------------------------------------
; Macro         haz05
; ----------------------------------------------------------------------------
; Description   explains the use of quantlet hazregll which calculates the
;		log-likelihood and its derivatives
; ----------------------------------------------------------------------------
 library("hazreg")
 dat=read("haz01.dat")  
 t = dat[,1]                        ; observed times                      
 delta = dat[,2]                    ; censoring indicator                       
 z = dat[,3:4]                      ; covariates                         
 {data,ties} = hazdat(t,delta, z)   ; preparing data
 beta = 1|2    
 {ll,ll1,ll2} = hazregll(data,beta)      
 ll
 ll1
 ll2
 