; -----------------------------------------------------------------
; Library        KALMAN
; -----------------------------------------------------------------
;   Macro        kalm04
; -----------------------------------------------------------------
;   Description  Applies the EM-algorithm to estimate unknown
;                parameters of the state-space model underlying
;                a given time serie.
; -----------------------------------------------------------------
;
  library("times")
  T = 100
  randomize(0)
  ex = normal(T)~(vec(1:T).*0)
  ey = normal(T).*2
  H = 1~0 
  F = #(0.5,1)~#(-0.3,0)
  x0 = #(0,0)
  ar2 = kemitor(T,x0,H,F,ey,ex)
;
; The initial values for EM-algorithm. You may try to use different ones.
;
  x0 = #(0,0)
  Sig = #(0,0)~#(0,0)
  H = 1~0
  F = #(5,1)~#(1,5)
  Q = 10
  R = #(1,0)~#(0,1)
  {Estmu, EstF, EstQ, EstR} = kem(ar2,x0,Sig,H,F,Q,R,20)
  Estmu
  EstF
  EstQ
  EstR
;
  smoothed = ksmoother(ar2,Estmu,Sig,H,EstF,EstQ,EstR)
;
  orig = vec(1:T)~ar2
  smoot = vec(1:T)~smoothed
  orig = setmask(orig, "line", "red", "thin")
  smoot = setmask(smoot, "line", "blue", "medium")
  disp = createdisplay(1,1)
  show(disp,1,1, orig, smoot)
  setgopt(disp,1,1, "title", "AR(2) with noise - EM estimated")


