; -----------------------------------------------------------------
; Library        QUANT
; -----------------------------------------------------------------
;   Macro        quant19
; -----------------------------------------------------------------
;   Description  An interactive choice between linear and 
;                Nadaraya Watson regression. For the Nadaraya Watson 
;                regression, the bandwidth can be interactively
;                selected.
; -----------------------------------------------------------------
  proc()=regression(x,y)
    selhead  = "Choose regression method"
    selitem  = "Linear regression"|"Nadaraya Watson"
    disp     = createdisplay(1,1)
    continue = 1
    show (disp, 1, 1, x~y)
    h = (max(x)-min(x))/20
    while (continue<>0)
      sel = selectitem (selhead, selitem)
      n   = sum(sel)
      if (n>0)
        if (sel[2]==1)
          h = readvalue ("Bandwidth", h)
        endif
        disp = createdisplay(1, n)
        i    = 1
        if (sel[1]==1)
          l = grlinreg(x~y)
          show (disp, 1, i, x~y, l)
          i = i+1
        endif
        if (sel[2]==1)
          w  = sort(x~y)
          mh = regest(w, h)
          l  = setmask(mh, "line")
          show (disp, 1, i, x~y, l)
          i = i+1
        endif
      endif
      continue = (n>0)
    endo
  endp

  library("plot")
  library("smoother")
  x = read("bostonh")
  regression(x[,13], x[,14])
