proc() = myquant(obs1)
; --------------------------------------------------------
;   Library      stats
; --------------------------------------------------------
;   See_also     linreg
; --------------------------------------------------------
;   Macro        myquant
; --------------------------------------------------------
;   Description  plot of the effect of outliers in linear 
;                regression model              
; --------------------------------------------------------
;   Usage        myquant(obs1)  
;   Input
;     Parameter    obs1
;     Definition   2x1 vector - coordinates of an outlier
;   Output
;     Parameter    
;     Definition 
; --------------------------------------------------------
;   Notes    works fine 
; --------------------------------------------------------
;   Example  myquant(#(10,45)) 
; --------------------------------------------------------
;   Result   produces a plot of true regression line and
;            the regression line 
; --------------------------------------------------------
;   Keywords     myquant
; --------------------------------------------------------
;   Reference    lecture notes, XploRe manual      
; --------------------------------------------------------
;   Link
; --------------------------------------------------------
;   Author       anonymous
;---------------------------------------------------------
     n = 10                          ; number of observations
     randomize(17654321)             ; set random seed
     beta =#(1, 2)                   ; define intercept and slope
     x = matrix(n)~sort(uniform(n))  ; create design matrix     
// new x-observation is
     x = x|(1~obs1[1])
     m = x*beta                      ; define regression line
     eps = 0.05*normal(n)            ; create obs error
// new y-observation 
     y = m[1:n] + eps                ; noisy line
     y = y|obs1[2]
     d = createdisplay(1,1)     
     dat = x[,2]~y                              
     tdat = x[,2]~m
     setmaskl(tdat, (1:rows(tdat))', 1, 1, 2) ; color blue
     setmaskp(tdat, 0, 0, 0)         ; reduce point size to min
     beta1 = inv(x'*x)*x'*y
     yhat = x*beta1
     hdat = x[,2]~yhat
     setmaskl(hdat, (1:rows(hdat))', 4, 2, 2) ; color red
     setmaskp(hdat, 0, 0, 0)    
     show(d, 1, 1, dat, tdat, hdat)
    endp