; -----------------------------------------------------------------
; Library        REGR
; -----------------------------------------------------------------
;   Macro        regr2
; -----------------------------------------------------------------
;   Description  Linear Regression with gls.
; -----------------------------------------------------------------
  library("graphic")          ; reads the library graphic
  library("stats")            ; reads the library stats
;
  z=read("westwood.dat")      ; reads the data
  z                           ; shows the data
  x=z[,2]                     ; puts the x-data into x
  y=z[,3]                     ; puts the y-data into y
;
  b=gls(x,y)        ; computes the GLS fit and stores the
                    ;     coefficients in the variable b
  b                 ; shows b
;
  yq=b*x[1:10]                 ; creates a vector with the 
                               ;    estimated values
  data=sort(x~y)               ; creates object with the data set
  data=setmask(data,"blue","cross")
                               ; creates graphical object 
                               ;    for the data
  rdata=sort(x~yq)             ; creates object with yq
  rdata=setmask(rdata,"reset","line","red","medium")
                               ; creates graphical object for yq
  glsplot=createdisplay(1,1)   ; creates display
  show(glsplot,1,1,data,rdata) ; shows the graphical objects
  setgopt(glsplot,1,1,"title","gls")
                               ; sets the window title

