; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      calibrLS kfilter2 rlsfil
; ----------------------------------------------------------------------------
; Macro         rkalm06
; ----------------------------------------------------------------------------
; Description   Calculates classical Kalman filter and rLS filter for data
;		without outliers
; ----------------------------------------------------------------------------
library("xplore")
library("plot")
library("kalman")

serie = read("kalman2.dat")
y = serie[,2]
mu = #(0,0)
Sig = #(0,0)~#(0,0)
H = #(1,0)'
F = #(0.5,1)~#(-0.3,0)
R = #(1,0)~#(0,0)
Q = 4
T = dim(y)

e=0.2
N=10000
eps=0.01
itmax=15
aus=4

ergLS=calibrLS(T,Sig,H,F,Q,R,e,N,eps,itmax,aus)


b=ergLS.b

res= kfilter2(y,mu,Sig, H,F,Q,R)
fx = res.filtX
fy=(H*fx')'
res= rlsfil(y,mu,Sig, H,F,Q,R,b)
frx = res.filtX
fry=(H*frx')'

origy = serie[,1]~serie[,2]
origy = setmask(origy, "line", "blue", "thin")

fy = serie[,1]~fy
fy = setmask(fy, "line", "red", "thin")
fry = serie[,1]~fry
fry = setmask(fry, "line", "green", "thin")
flags = serie[,1]~(res.clipInd)
flags=paf(flags,flags[,2]==1)
flags[,2]=0
setmaskp(flags,4, 3, 4)
  
disp = createdisplay(1,1)
show(disp,1,1,origy,fy,fry,flags)
setgopt(disp,1,1, "title", "KalmanData2 in Observation Space")
setgopt(disp,1,1, "xlabel", "t") 
setgopt(disp,1,1, "ylabel", "y, y-rLS, y-Kalman") 
 