proc(FGNx)=FGNx(m,H)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    FGNgk,FGNx,fft,FBMx
; ---------------------------------------------------------------------
; Macro       FGNx
; ---------------------------------------------------------------------
; Description Simulation of a series of fractional Gaussian noise (not
;							standard fractional Gaussian noise) by a method proposed
;							by Davies and Harte
; ---------------------------------------------------------------------
; Usage       (FGNx)=FGNx(m,H)
; Input       
; Parameter   m Length of the generated series, must be a power of 2
;								due to the use of the Fast Fourier Transform, for
;								instance ...,64,128,256,512,1024,2048,... and so on
; Definition  
; Parameter   H	Hurst Koeffizient as self similarity parameter
; Definition  
; Output      
; Parameter   FGNx Vector of size m of the generated series
; Definition  
; ---------------------------------------------------------------------
; Notes    		uses the procedures FGNx and FGNgk   
; ---------------------------------------------------------------------
; Example     x=FGNx(4,.7)
; ---------------------------------------------------------------------
; Result      Contents of x
;							[1,]  0.84046
;							[2,] -0.21559
;							[3,] -0.21796
;							[4,] -0.66536
; ---------------------------------------------------------------------
; Keywords    fractional Gaussian Noise, fractional Brownian Motion,
;							self similarity, long memory
; ---------------------------------------------------------------------
; Reference   Beran, J. "Statistics for Long Memory Processes", Chapman
;							& Hall 1994
;							Davies, R.B. and Harte, D.S. "Test for Hurst effect"
;							Biometrica 74, 1987
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wnsche, 000402
; ---------------------------------------------------------------------
//
n=m+1
z=normal(2*n)
i=0
z[1]=z[1]*sqrt(2)
z[n]=z[n]*sqrt(2)
z[n+1]=0
z[2*n]=0
k=0
zk=matrix(2*n-2)
while (k<2*n-2)
	k=k+1
	if (k<=n)
		zk[k]=z[k]
	else
		zk[k]=z[2*n-k]
	endif
endo
faktor=1/(2*sqrt(n-1))
gk=FGNgk(m,H)
sqrtgk=sqrt(gk)
zsgk=matrix(2*n-2)
k=0
while (k<2*n-2)
	k=k+1
	zsgk[k]=zk[k]*sqrtgk[k]
endo
hilfsmatrix=matrix(2*n-2)-matrix(2*n-2)
zsgk=zsgk~hilfsmatrix
xt=faktor*fft(zsgk)
xt=xt[1:m]
FGNx=xt[,1]
endp
		