proc(A,b,V,ctrl) = ICerz(e,FI,A0,b0,N,eps,itmax,expl,fact0,aus)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC
; -----------------------------------------------------------------
;   Macro        ICerz
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rICfil:
;
;                - if possible - generates for Scores 
;                Lambda~N(0,FI) (FI:: Fisher-Info) 
;                a Hampel-Krasker-IC    psi 
;                to efficiency loss  e,  
;                i.e.  
;
;                E psi Lambda' = unit(p)  E psi=0   (1)
;
;                E |psi|^2= (1+e) tr (FI^{-1})             (2)
;
;                and psi= A Lambda w_b
;
;                w_b=min(1,b/|A Lambda|)
;
;                for dim p==1 a Newton-Algo is used
;                     for both a and b, 
;                for dim p>=2 for A a fixed-point-algorithm 
;                     and for b a "careful" bisection method 
;                      is used. 
;                Integration for A and p==2 is done by 
;                    a Romberg-procedure. 
;                Integration for A and p>2 is done by 
;                    a MC-procedure.
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          {A,b,V,ctrl}=ICerz(e,FI,A0,b0,N,eps,itmax,expl,fact0,aus)
;   Input
;     Parameter   e
;     Definition     numeric; efficiency loss to attain
;     Parameter   FI    
;     Definition     p x p; Fisher-Information
;     Parameter   A0  
;     Definition     p x p; starting value for A; if 0 is entered I^{-1} is taken
;                                 else if p>1 and dim(A0)==1 FI^{-1}*A0 is taken
;                                  and if p==1 and A0<0  , -A0/FI is taken     
;     Parameter   b0    
;     Definition     numeric; starting value for clipping height; if 0 is entered
;                        4*max(vec(abs("A0"))) [i.e. perhaps modified]
;     Parameter    N
;     Definition      integer; MC-sample size / integration grid-points
;     Parameter    eps
;     Definition      numeric; exactitude
;     Parameter    itmax
;     Definition      integer; maximal number of ICerztions
;     Parameter    expl
;     Definition      numeric; threshold for the changes in abs. value of A: 
;                             beyond this value convergence is uncertain  ~ 4
;     Parameter    fact0
;     Definition      numeric (>1)!; factor determining how fast we descend from b to b
;     Parameter    aus
;     Definition      integer; 0: no output during execution, 1: some output, 2: more output, 3: a lot of output
; Output                                                           
;     Parameter   A
;     Definition     p x p;  Lagrange-Multiplyer solving (1)
;     Parameter   b
;     Definition     1;  clipping height
;     Parameter   V
;     Definition     p x p;  corresponding Covariance
;     Parameter   ctrl
;     Definition     integer; tells if convergence "happened"
; -----------------------------------------------------------------
; Notes
;     Not to be used outside of rICfil!
;
;     Is called by calibrIC.
;
;     Calles [within kalman.lib]  itera, abinfonewton. 
;
;      The Output produced if aus>=1 is not identical with the output parameters.
;      (aus>=1) is for interactive use ,   success is controlled by "verbal" output.
;      (aus==0) is for other quantlets calling ICerz;
;                       success is controlled by variable "ctrl".
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------

ctrl=0  
p=rows(FI)

if (max(abs(vec(FI)))==0)
    FIs=1
else
    FIs=FI
endif 

Imax=1.6*sqrt(max(vec(abs(ginv(FIs)))))



switch
  
  case(p==1)

    a4=(aus>3)
    At0=1
    bt0=1.4
    
    ctrl=1
    
    while ((ctrl!=0)&&(bt0<100))
       erg=abinfonewton(1,e,itmax,eps,At0,bt0,a4)
       At0=At0*expl
       bt0=bt0*sqrt(expl)
       ctrl=erg.ctrl+(erg.b<=0) +(erg.A<=0)
    endo
    
    if (bt0>=100)
        bt=b0
        At=At0
        while (ctrl!=0)
           erg=abinfonewton(1,e,itmax,eps,At0,bt0,a4)
           At0=At0*expl
           bt0=bt0/sqrt(expl)
           ctrl=erg.ctrl+(erg.A<0)+(erg.b<0)
        endo
    endif


    A=erg.A/FIs
    b=erg.b/sqrt(FIs)
    V=(1+e)/FIs
    ctrl=erg.ctrl

  break

  case (p>1) 
    
    ;Calculation of the trace of FIs^{-1}
    trsit=unit(p).*ginv(FIs)
    trsit=sum(vec(trsit)); trace of classically optimal V

    fact=abs(fact0)
    if (fact <1) 
        fact=1/fact
    endif
     
    if (b0<=0)
        b=Imax
    else
        b=b0
    endif

    if (aus>0)
       "finding a (large) b that works"
    endif

    abr=1

    while(abr!=0)
       
       erg=itera(A0,FIs,b,N,eps,itmax,expl)
       At=erg.A
       abr=erg.ctrl
       trV=sum(vec(unit(p).*erg.V))     ; trace of V
       eff=trV/trsit-1
       abr=abr*(abs(eff-e)>eps); exit the loop, if eff is close to e, too
       
       if (aus>2)
           b
           erg.A
           eff
       endif
      
       if (abr==1)
           fact=fact^1.5 
       endif
      
       b=b * fact
    
    endo 
      
    b=b/fact
    
    if ((abs(eff-e)<eps)&&(erg.ctrl==0))
        A=At
        V=erg.V
        ctrl=0
        abr=0
    else
        abr=1
    endif    
    
    if(aus>0)
       b
       At
       eff
    endif
    
    i=0
    
    if (abr>0)
        
        if (aus>0)
            "finding two admissible (A,b) - points for a bisection method"
        endif

        if (eff>e)
       

            if (aus>0)
                "easier case: finding a right admissible b-point "
                "with smaller eff than e"
            endif
       
            Atl=At
            bl=b
            effl=eff
            Vl=erg.V         
        
            while ( ((abr!=0)||((eff>e)&&(abs(eff-e)>eps)))&&(b<10*Imax))

               erg=itera(ginv(FIs),FIs,b,N,eps,itmax,expl)

               abr=erg.ctrl
               trV=sum(vec(unit(p).*erg.V))     ; trace of V
               eff=trV/trsit-1

               if (abr>1)
                   b=b/fact^2
               endif
               if (abr!=0)
                   b=b*sqrt(fact)
               endif
               b=b *fact

               if (aus>3)
                   b
                   erg.A
                   eff
               endif

            endo 

            if (b>=10*Imax)
               ;error
            endif 

            Atr=erg.A

            br=b
            Atr=At
            effr=eff
            Vr=erg.V 

            if ((abs(eff-e)<eps)&&(erg.ctrl==0))
                A=At
                V=erg.V
                ctrl=0
            endif    
 
        else  ; eff<e

            if (aus>0)
                "more difficult case: finding a left admissible b-point" 
                "with bigger eff than e"
            endif

            br=b
            Atr=At
            effr=eff
            Vr=erg.V
            bd=1
            noch=1
        
            nA=max(abs(vec(At)))

            while (noch==1)
             
               i=i+1
     
               while (bd<eps)
                  bd=bd*sqrt(fact)
               endo
    
               bd=bd/fact
               b=b-bd
      
              ; mit zulaessigem Start-A bewegen wir uns auf b zu
      
               nA0=nA

               erg=itera(At,FIs,b,N,eps,itmax,expl)
               abr=erg.ctrl
               trV=sum(vec(unit(p).*erg.V))     ; trace of V
               eff=trV/trsit-1

               if (aus>2)
                  b
                  erg.A
                  eff
               endif

               if (erg.ctrl==0)

                    At=erg.A
                    nA=max(abs(vec(At)))
         
                    if (nA/nA0>expl)
                        bd=bd/fact
                    endif
          
                    if (abs(nA/nA0-1)<0.1)
                        bd=bd*fact
                    endif

               endif
           
   
     
               if ((eff>e)&&(abr==0))
                    noch=0
                    Atl=At
                    effl=eff
                    bl=b
                    Vl=erg.V
               endif
      
               if ((abs(eff-e)<eps)&&(abr==0))
                   noch=0
                   A=At
                   V=erg.V
                   ctrl=0
               endif
               
               if (abr!=0)
                   b=b+bd
               endif
          
               if (i>10*itmax) 
                   noch=0
                   ;error
               endif
      
            endo ;searching a left admissible point

      
        endif ; finding left and right endpoint


        if ((aus>0)&&(abs(eff-e)>eps))
            "now a 'careful' bisection method"
        endif

        if ((aus>0)&&(abs(eff-e)>eps))
            bl
            br
            Atl
            Atr
            effr
            effl
            db=br-bl
        endif

        if ((i<10*itmax)&&(abs(eff-e)>eps))

            i=0
            while ((db>eps)&&(i<itmax)&&(abs(eff-e)>eps))

               ;bisection method

               i=i+1
               b=(bl+br)/2
               br0=b
               abr=1
               At=(Atl+Atr)/2

             ; searching an admissible intermediate point between bl and br
             ; as the algorithm will not necessarily converge in the midpoint
               
               while ((abr!=0)&&(br-br0>eps)&&(abs(eff-e)>eps))
                  
                  b=br0
                  erg=itera(At,FIs,b,N,eps,itmax,expl)
                  br0=(br+br0)/2 
                  At=(At+Atr)/2
                  abr=erg.ctrl
                  trV=sum(vec(unit(p).*erg.V))     ; trace of V
                  eff=trV/trsit-1
                
                  if (aus>2)
                      b
                      erg.A
                      eff
                  endif
              
               endo
              
               if (eff>e)
                   bl=b
                   Atl=At
                   effl=eff
                   Vl=erg.V
               else
                   br=b
                   Atr=At
                   effr=eff
                   Vr=erg.V
               endif

               if (aus>0)
                   b
                   At
                   eff
               endif
            
               db=br-bl   
              
            endo
            ctrl=erg.ctrl
            if ((eff-effr)>(effl-eff))
                b=bl
                A=Atl
                eff=effl
                V=Vl
            else
                b=br
                A=Atr
                eff=effr
                V=Vr
            endif
        else
            if (abs(eff-e)>eps)
                ctrl=abr+ctrl+16
            endif
        endif
    endif
    

    if (aus>0)
        b
        At
        V
        eff
    endif
    
    break
    
    default
    break 

endsw
endp
