proc (out0)=VaRauxdiagcat(a,b,sig,real,g)
; ----------------------------------------------------------------------------
; Library        VaR
; ----------------------------------------------------------------------------
;  See_also      VaRest VaRopt VaRdiagplot VaRdiagtable VaRgrdiag
; ----------------------------------------------------------------------------
;   Macro        VaRauxdiagcat
; ----------------------------------------------------------------------------
;   Description  subroutine for VaRdiagtable.
; ----------------------------------------------------------------------------
;   Usage        out0 = VaRauxdiagcat(a,b,sig,real,g)
;   Input
;     Parameter   a  
;     Definition        scalar, lower limit for the interval.
;     Parameter   b
;     Definition        scalar, upper limit for the interval.
;     Parameter   sig
;     Definition        nx1 vector of predicted standard deviations 
;                           (assume normality)
;     Parameter   real
;     Definition        nx1 vector of realizations.
;     Parameter   g
;     Definition        scalar, number of grid points.
;   Output
;     Parameter   out0
;     Definition        g x 3  matrix, the "contingency table",
;                       1st column contains relative frequencies 
;                       of predicted probabilities.
;                       2nd and 3rd column contain relative
;                       frequencies of predicted probabilities 
;                       conditioned on the result (whether the observations
;                       fall inside or outside the specified interval)
; ----------------------------------------------------------------------------
;   Author    Zdenek Hlavka, 2000/07/13 
; ----------------------------------------------------------------------------
  p=cdfn(b/sig)-cdfn(a/sig)
  error(countNaN(p)>0,"This values of intervals not allowed!")
  p=p-(p==1)*(1/(2*g))+(p==0)*(1/(2*g))
  real=(real<=b)&&(real>=a)
  {ind,pr}=bindata(p,(1/g),0,real~(1-real))
  out=paf(ind~pr,pr[,1]>0)|((0:(g-1))~(0*matrix(g,3)))
  {ind0,pr0}=bindata(out[,1],1,-0.5,out[,2:4])
  out0=paf(ind0~pr0[,2:4],pr0[,1]>0)
  out0=sort(out0,1)[,2:4]
endp

