proc (table)=VaRdiagtable(int,sig,real,g)
; ----------------------------------------------------------------------------
; Library        VaR
; ----------------------------------------------------------------------------
;  See_also      VaRest VaRdiagplot VaRgrdiag VaRtimeplot
; ----------------------------------------------------------------------------
;   Macro        VaRdiagtable
; ----------------------------------------------------------------------------
;   Description  produces table containing frequencies of predictive
;                probabilities of the observations falling into specified
;                intervals.
; ----------------------------------------------------------------------------
;   Keywords     VaR
; ----------------------------------------------------------------------------
;   Usage        table = VaRdiagtable(int,sig,real,g)
;   Input
;     Parameter   int  
;     Definition        mx2 matrix containing the intervals (in the rows).
;     Parameter   sig
;     Definition        nx1 vector of predicted standard deviations 
;                           (assume normality)
;     Parameter   real
;     Definition        nx1 vector of realizations.
;     Parameter   g
;     Definition        scalar, number of grid points.
;   Output
;     Parameter   table
;     Definition        g x 3  matrix, the "contingency table",
;                       1st column contains relative frequencies of 
;                       predicted probabilities.
;                       2nd and 3rd column contain relative
;                       frequencies of predicted probabilities 
;                       conditioned on the result (whether the observations
;                       fall inside or outside the specified interval)
; ----------------------------------------------------------------------------
;   Example      library("VaR")
;                x=read("kupfer")       ; time series
;                x=x[1:1001]  
;                y=diff(log(x))         ; returns
;                sig=VaRest(y)[,2]/qfn(0.99)   
;                y=y[251:1000] 
;                VaRdiagtable((-0.01~0.01),sig,y,10)
; ----------------------------------------------------------------------------
;   Result       [ 1,]        0        0        0 
;                [ 2,]        0        0        0 
;                [ 3,]        0        0        0 
;                [ 4,]       15        8        7 
;                [ 5,]       90       41       49 
;                [ 6,]      520      317      203 
;                [ 7,]      125       97       28 
;                [ 8,]        0        0        0 
;                [ 9,]        0        0        0 
;                [10,]        0        0        0 
; ----------------------------------------------------------------------------
;   Author    Zdenek Hlavka, 2000/07/13
; ----------------------------------------------------------------------------
  error(cols(int)!=2,"Wrong dimension of parameter int!")
  error(rows(int)<1,"Parameter int has zero rows!")
  error(sum(sig<=0)>0,"Estimates of sigma must be positive!")
  rw=rows(int)
  i=1
  table=0*matrix(g,3)
  while (i<=rw)
    table=table+VaRauxdiagcat(int[i,1],int[i,2],sig,real,g)
    i=i+1
  endo
endp
