proc()=VaRtimeplot(y,VaR, VaR1,VaR2,VaR3, opt)
; ----------------------------------------------------------------------------
; Library        VaR
; ----------------------------------------------------------------------------
;  See_also      VaRest VaRopt
; ----------------------------------------------------------------------------
;   Macro        VaRtimeplot
; ----------------------------------------------------------------------------
;   Description  shows the time plot of VaR forecasts and 
;                the associated changes of the P&L of the portfolio.
; ----------------------------------------------------------------------------
;   Keywords     VaR
; ----------------------------------------------------------------------------
;   Usage        VaRtimeplot(y,VaR{,VaR1,{,VaR2{,VaR3}}}{,opt})
;     Input  
;       Parameter   y  
;         Definition    n x d  matrix, the returns of d time series.
;       Parameter   VaR  
;         Definition    (n-h) x 1 or (n-h) x 2  matrix, VaR forecasts.
;       Parameter   VaR1  
;         Definition    (n-h) x 1 or (n-h) x 2  matrix, VaR forecasts.
;       Parameter   VaR2  
;         Definition    (n-h) x 1 or (n-h) x 2  matrix, VaR forecasts.
;       Parameter   VaR3  
;         Definition    (n-h) x 1 or (n-h) x 2  matrix, VaR forecasts.
;       Parameter   opt
;         Definition    optional, a list with optional input. The function
;                       "VaRopt" can be used to set up this parameter.
;                       The order of the list elements is not important.
;                       Parameters which are not given are replaced by 
;                       defaults (see below).
;       Parameter   opt.h
;         Definition    positive integer, window width. 
;                       If not given, set to 250.
;       Parameter   opt.w
;       Definition      scalar, 1 x d or n x d, weights for assets. 
;                       If not given, set to 1.
;       Parameter   opt.name
;         Definition    string, prefix for the output. If not given, "VaR"
;                       is used.
;       Parameter   opt.title
;         Definition    string, title for the output. If not given, a default
;                       is set.
;       Parameter   opt.color
;         Definition    string vector, colors for different VaR
;                       functions. Possible values are the color
;                       strings from setmask. The default is "black".
;       Parameter   opt.style
;         Definition    string vector, line styles for different VaR
;                       functions. Possible values are the line
;                       styles from setmask. The default is "solid".
;       Parameter   opt.size
;         Definition    string vector, line thickness for different VaR
;                       functions. Possible values are the line
;                       sizes from setmask. The default is "thin".
;       Parameter   opt.data
;         Definition    string vector, contains color, style and size
;                       (in that order) for portfolio data points.
;                       The default is "black"|"point"|"medium".
;       Parameter   opt.exceed
;         Definition    string vector, contains color, style and size
;                       (in that order) for points that should be
;                       marked as exceeding the VaR.
;                       The default is "black"|"point"|"medium".
;       Parameter   opt.plot
;         Definition    string vector, default is "all" for upper and 
;                       lower VaR forecasts, use "low" for lower only.
;     Output
;       Parameter   VaRtimeplot
;         Definition    or  opt.name+"timeplot",
;                       display, containing portfolio data and VaR 
;                       forecasts.
; ----------------------------------------------------------------------------
;   Example   library("VaR")
;             x=read("kupfer")       ; time series
;             x=x[1:1001]  
;             y=diff(log(x))         ; returns
;             VaR=VaRest(y)          ; VaR 
;             opt=VaRopt("exceed","blue"|"fillcircle"|"small")
;             VaRtimeplot(y,VaR,opt) ; VaR time plot
; ----------------------------------------------------------------------------
;   Result    The VaR forecasts (using method RMA) are plotted 
;             together with the portfolio returns. Returns which
;             exceed the VaR are marked in blue.
; ----------------------------------------------------------------------------
;   Example   library("VaR")
;             x=read("kupfer")       ; time series
;             x=x[1:1001]  
;             y=diff(log(x))         ; returns
;             VaRrma=VaRest(y,"RMA") ; VaR using RMA 
;             VaRema=VaRest(y,"EMA") ; VaR using EMA
;             VaRmad=VaRest(y,"MAD") ; VaR using MAD
;             opt=VaRopt("color","red"|"blue"|"green")
;             VaRtimeplot(y,VaRrma,VaRema,VaRmad,opt)  
; ----------------------------------------------------------------------------
;   Result    The VaR forecasts (using methods RMA, EMA and MAD) are plotted 
;             together with the portfolio returns.
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/07/13
; ----------------------------------------------------------------------------
;
; check initial errors
;
  bad=(rows(dim(y))>2)
  error(bad>0,"y must be vector or matrix")
;
  n=rows(y)
  d=cols(y)
;
  nov=1+(exist(VaR1)==1)+(exist(VaR2)==1)+(exist(VaR3)==1)
  if (exist(VaR1)==9)
    opt=VaR1
  else
    if (exist(VaR2)==9)
      opt=VaR2
    else
      if (exist(VaR3)==9)
        opt=VaR3
      endif
    endif
  endif
;
; set the defaults
;
  h=250
  lam=0.04
  dist=0
  alpha=0.01
  w=matrix(1,d)
  name="VaR"
  title="VaR timeplot"
  color="black"
  style="solid"
  size="thin"
  data="black"|"point"|"medium"
  exceed="black"|"point"|"medium"
  plot="all"
;
; now check which optional values have been given
;
  if (exist(opt)>0)
    if (comp(opt,"h")>0)
      opt.h=opt.h[1]
      notgood=(opt.h>=n-1)||(opt.h<2)
      error(notgood>0, "VaRest: Window width h is unusable")
      if (notgood==0)
        h=opt.h
      endif
    endif
    if (comp(opt,"w")>0)
      notgood=((cols(opt.w)!=d)&&(cols(opt.w!=1)))
      notgood=notgood || ((rows(opt.w)!=n)&&(rows(opt.w!=1)))
      if (notgood==0)
        w=opt.w
      endif
    endif
    if (comp(opt,"name")>0)
      name=opt.name
    endif
    if (comp(opt,"title")>0)
      title=opt.title
    endif
    if (comp(opt,"color")>0)
      color=opt.color
    endif
    if (comp(opt,"style")>0)
      style=opt.style
    endif
    if (comp(opt,"size")>0)
      size=opt.size
    endif
    if (comp(opt,"data")>0)
      data=opt.data
    endif
    if (comp(opt,"exceed")>0)
      exceed=opt.exceed
    endif
    if (comp(opt,"plot")>0)
      plot=opt.plot
    endif
  endif
;
  p=sum(y.*w,2) ; portfolio
;
  lt=((h+1):n)~p[(h+1):n]
  iup= (p[(h+1):n]>VaR[,2])
  ilo= (p[(h+1):n]<VaR[,1])
  if (plot=="all")
    iall=iup+ilo
  else
    iall=ilo
  endif
  inum=1:rows(iall)
  ifmt=string("%%.",inum)+string("%1.0f0s",1-iall)+"%."+string("%1.0f0s",iall)
  icolor=string(ifmt,string(data[1],inum),string(exceed[1],inum))
  istyle=string(ifmt,string(data[2],inum),string(exceed[2],inum))
  isize=string(ifmt,string(data[3],inum),string(exceed[3],inum))
  lt=setmask(lt,icolor,istyle,isize)
;
  VaRup=setmask(((h+1):n)~(VaR[,2]),"line",color[1],style[1],size[1])
  VaRlo=setmask(((h+1):n)~(VaR[,1]),"line",color[1],style[1],size[1])
  if (nov>1)
    VaR1up=setmask(((h+1):n)~(VaR1[,2]),"line",color[2],style[2],size[2])
    VaR1lo=setmask(((h+1):n)~(VaR1[,1]),"line",color[2],style[2],size[2])
  endif
  if (nov>2)
    VaR2up=setmask(((h+1):n)~(VaR2[,2]),"line",color[3],style[3],size[3])
    VaR2lo=setmask(((h+1):n)~(VaR2[,1]),"line",color[3],style[3],size[3])
  endif
  if (nov>3)
    VaR3up=setmask(((h+1):n)~(VaR3[,2]),"line",color[4],style[4],size[4])
    VaR3lo=setmask(((h+1):n)~(VaR3[,1]),"line",color[4],style[4],size[4])
  endif
;
  exec( name+"timeplot=createdisplay(1,1)" )
  if (nov==1)
    if (plot=="all")
      exec("show("+name+"timeplot,1, 1, lt, VaRup, VaRlo)")
    else
      exec("show("+name+"timeplot,1, 1, lt, VaRlo)")
    endif
  endif
  if (nov==2)
    if (plot=="all")
      exec("show("+name+"timeplot,1, 1, lt, VaRup, VaRlo, VaR1up, VaR1lo)")
    else
      exec("show("+name+"timeplot,1, 1, lt, VaRlo, VaR1lo)")
    endif
  endif
  if (nov==3)
    if (plot=="all")
      exec("show("+name+"timeplot,1, 1, lt, VaRup, VaRlo, VaR1up, VaR1lo, VaR2up, VaR2lo)")
    else
      exec("show("+name+"timeplot,1, 1, lt, VaRlo, VaR1lo, VaR2lo)")
    endif
  endif
  if (nov==4)
    if (plot=="all")
      exec("show("+name+"timeplot,1, 1, lt, VaRup, VaRlo, VaR1up, VaR1lo, VaR2up, VaR2lo, VaR3up, VaR3lo)")
    else
      exec("show("+name+"timeplot,1, 1, lt, VaRlo, VaR1lo, VaR2lo, VaR3lo)")
    endif
  endif
  tl="title"
  titl=title
  xl="xlabel"
  xlabl="time"
  yl="ylabel"
  ylabl="returns"
  exec( "setgopt("+name+"timeplot,1,1,tl,titl,xl,xlabl,yl,ylabl)" )
endp









