proc(A,b,ctrl) = abinfonewton(p,e,itmax,eps,A0,b0,aus)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC, ICerzsep
; -----------------------------------------------------------------
;   Macro        abinfonewton
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rICfil:
;                solves - if possible - by explicit integration
;                and Newton-Algorithm
;       E [|AX|^2 \min{1,b/|AX|}]=1, E [|AX|^2 \min{1,b^2/|AX|^2}]=(1+e)p
;                for X ~ N_p (0,unit(p))
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          {A,b,ctrl}=abinfonewton(p,e,itmax,eps,A0,b0,aus)
;   Input
;     Parameter   p
;     Definition     integer; dimension of X
;     Parameter   e  
;     Definition     numeric; efficiency loss to attain;
;     Parameter    itmax
;     Definition      integer; maximal number of iterations
;     Parameter    eps
;     Definition      numeric; exactitude
;     Parameter   A0
;     Definition     numeric; starting value for a
;     Parameter   b0
;     Definition     numeric; starting value for b
;     Parameter   aus
;     Definition     integer; decides whether to write results on output [1] or not (else)
; Output                                                           
;     Parameter   A
;     Definition     numeric; Lagrange-Multiplyer to achieve Fisher-Consistency
;     Parameter   b
;     Definition     numeric; clipping height achieving e as rel. effiency loss
;     Parameter   ctrl
;     Definition     numeric; decides whether convergence "happened"
; -----------------------------------------------------------------
; Notes
;      Not to be used outside of rICfil!
;
;      The Output produced if aus==1 is not identical with the output parameters.
;      (aus==1) is for interactive use ;   success is controlled by "verbal" output.
;      (aus==0) is for other quantlets calling abinfonewton; 
;      success is controlled by variable "ctrl".
;
;      Is called by ICerz ICerzsep.
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
  
gr=30
 
f=matrix(2)
x=matrix(2)
fabl=matrix(2,2)
 
;controll: reasonable starting values?
A=(A0>0)*A0+(A0<=0)*p
b=(b0<=0)*1.6*A+(b0>0)*b0
 
alt=0
Aalt=0
fbet=1
it=0
del=1
 
x[1]=A
x[2]=b
 
c=b/A
 
vu=betrnormV(c,p)
eu=betrnormE(c,p)
eg=betrnormE(gr,p)
fu=betrnormF(c,p)
 
f[1]=vu+c*(eg-eu)-p/A
f[2]=vu+c*c*(1-fu)-(1+e)*p/A/A
 
if (abs(f[1])<10^(-20))
f[1]=0
endif
if (abs(f[2])<10^(-20))
f[2]=0
endif
fbet=sqrt(f[1]*f[1]+f[2]*f[2])
 
while (((del>eps)||(fbet>eps))&&(it<itmax))
 
   fabl[1,1]=-1/A*(c*(eg-eu)-p/A)
   fabl[1,2]= 1/A*(eg-eu)
   fabl[2,1]= -2/(A^3)*(b*b*(1-fu)-(1+e)*p)
   fabl[2,2]=2*c/A*(1-fu)
 
   Aalt=A
   balt=b
 
   x=x-ginv(fabl)*f

   A=x[1]
   b=x[2]
 
   c=b/A
 
   vu=betrnormV(c,p)
   eu=betrnormE(c,p)
   fu=betrnormF(c,p)
 
   f[1]=vu+c*(eg-eu)-p/A
   f[2]=vu+c*c*(1-fu)-(1+e)*p/A/A
 
   fbet=sqrt(f[1]*f[1]+f[2]*f[2])
 
   if ((abs(A-Aalt)<10^(-20))&&(abs(b-balt)<10^(-20)))
       del=0
   else
       del=sqrt((A-Aalt)^2+(b-balt)^2)
   endif
 
   it=it+1
   if ((A<=0)||(A>100/((A==0)+abs(A)) )|| (b<=0))
   it=itmax+2
   ctrl=4
   endif
endo
 
if (aus==1)
   e
   A
   b
   t1=A*(vu+c*(eg-eu))
   t2=A*A*(vu+c*c*(1-fu))
   "Control of the defining equations:"
   "Value of tr(Ew[psi Lambda'])  [to be _p_ ]:  _t1_"
   "Value of tr(Ew[psi psi'])  [to be (_((1+e)p)_ ]:  _t2_"
endif
 
ctrl=(it>=itmax)+(b<0)+(A<0)+(A>10)+(b>10)
endp
