proc(delt,alphahat,lim,hd)=adedis(z,x,y,h,hfac,c0,c1) 
; -----------------------------------------------------------------
; Library        metrics
; -----------------------------------------------------------------
;  See_also      dwade adeind adeslp ndw
; -----------------------------------------------------------------
;   Macro        adedis 
; -----------------------------------------------------------------
;   Keywords     single index model, semiparametric estimation, 
;		 weighted average derivative
; -----------------------------------------------------------------
;   Description  adedis computes estimates of the slope coefficients 
;                in a single index model. The coefficents of the 
;                continuous variables are estimated by (an average of) 
;                dwade (density-weighted average derivtive) estimates. 
;                The coefficients of the disrete 
;                explanatory variables are estimated by the method
;                proposed in Horowitz and Haerdle, JASA 1996. 
; -----------------------------------------------------------------
;   Reference    Horowitz and Haerdle (1996), "Direct Semiparametric Estimation 
;                of a Single-Index Model with Discrete Covariates," 
;                Journal of the American Statistical Association, 91, 1632-1640
; -----------------------------------------------------------------
;   Usage        {delt,alphahat,lim,hd}=adedis(z,x,y,h,hfac,c0,c1)     
;   Input
;     Parameter   z  
;     Definition      n x d1 matrix , the observed discrete explanatory variables    
;     Parameter   x  
;     Definition      n x d2 matrix , the observed continuous explanatory variables    
;     Parameter   y 
;     Definition      n x 1 matrix , the observed response variable       
;     Parameter   h  
;     Definition      d2 x 1 or 1 x 1 matrix , bandwidth for dwade etimation           
;     Parameter   hfac  
;     Definition      scalar, to scale bandwidth for estimation of the link function           
;     Parameter   c0,c1  
;     Definition      scalars , monotonicity constants            
;   Output                      
;     Parameter   delta 
;     Definition      d2 x 1 matrix, the density weighted average          
;                     derivative estimates of the coefficients of
;                     the elements of x.  
;     Parameter   alphahat 
;     Definition      d1 x 1 matrix, the estimates of the coefficients of
;                     the elements of z.  
;     Parameter   lim 
;     Definition      2 x 1 matrix, the limits of integration corrsponding to the
;                     parameters v0 and v1 in the paper of Horowitz and Haerdle.
;     Parameter   hd  
;     Definition      d3 x 1 matrix , bandwidth for estimation of the link function
;                     for each of the d3 distinct values of the matrix z           
; -----------------------------------------------------------------
;   Example   library("metrics")
;       randomize(10178)
;        n=1000
;        z=(uniform(n).>0.5)~(uniform(n).<0.5)
;        x=normal(n)~normal(n)
;        ystar=1.5*z[,1]+0.25*z[,2]+1*x[,1]+2*x[,2]+normal(n)
;        y=(ystar>=0)
;        h = 0.2*(max(x)-min(x))'   
;        hfac = 1.5
;        c0=0.10564
;        c1=0.97725
;        {d,a,lim,hd}=adedis(z,x,y,h,hfac,c0,c1)
;        d
;        a
;        lim
;        hd
; -----------------------------------------------------------------
;   Result    The slope coefficients, d, and intercept coefficients, a,
;	      of a single index model E[y|x]=g(d'x+a'z) are computed.
;             The integration limits (lim) and bandwidths (hd) used in the 
;	      estimation procedure are returned.
; -----------------------------------------------------------------
;   Author    Charles de Garchy, 972412  
; -----------------------------------------------------------------
n=rows(z)
{zmat,r}=discrete(z)
nz = rows(zmat)
indvec = matrix(rows(x))
indx = aseq(1,n,1)
wgt=(r/rows(z))
   jj = 1
   while (jj <= nz)
     tmp = zmat[jj,].*indvec
     cc = (z!=tmp)
     ccs = sum (cc,2)
     ind = paf(indx,ccs.=0)
      if (jj == 1)
        delt = wgt[jj,]*dwade(x[ind,],y[ind,],h)
     else 
        delt = delt~(wgt[jj,]*dwade(x[ind,],y[ind,],h))
     endif 
      
     jj = jj+ 1     
   endo 
   delt=sum(delt')'
  delt=delt./delt[1]    
lim1 = 0*matrix(nz,1)
lim2 = 0*matrix(nz,1)
indvec = matrix(rows(x))
indx = aseq(1,n,1)
b = delt
jj = 1
   
while (jj <= nz)
     tmp = zmat[jj,].*indvec
     cc = (z!=tmp)
     ccs = sum (cc,2)
     ind = paf(indx,ccs.=0)
     xb = x[ind,]*b     
     yb = y[ind,]
      
     hx = hfac*sqrt(var(xb))*rows(xb)^(-1/7.5)
     lim1[jj] = min(xb)+hx
     lim2[jj] = max(xb)-hx
     jj = jj+ 1     
endo 
lim1 = max(lim1)
lim2 = min(lim2)
lim = lim1|lim2
;test=limv   
jj = 1
xb=matrix(rows(x))
yb=matrix(rows(y))
hd=matrix(rows(zmat))
zahl=0*matrix(rows(zmat))
     tmp = zmat[1,].*indvec
     cc = (z!=tmp)
     ccs = sum (cc,2)
     ind = paf(indx,ccs.=0)
     zahl[1]=rows(ind)
     xb[1:zahl[1]] = x[ind,]*b  
     yb[1:zahl[1]] = y[ind,]
     hd[1] = hfac*sqrt(var(xb[1:zahl[1]]))*rows(xb[1:zahl[1]])^(-1/7.5)
jj=2
while (jj <= nz)
     tmp = zmat[jj,].*indvec
     cc = (z!=tmp)
     ccs = sum (cc,2)
     ind = paf(indx,ccs.=0)
     zahl[jj]=rows(ind)
     bd=sum(zahl)       
     unten=bd-zahl[jj,]+1
     oben=bd            
     xb[unten:oben,] = x[ind,]*b        
     yb[unten:oben,] = y[ind,]
     hd[jj] = hfac*sqrt(var(xb[unten:oben,]))*rows(xb[unten:oben,])^(-1/7.5)    
     jj=jj+1
endo
     integ=matrix(nz)   
     xxb = xb[1:zahl[1],]       
     yyb = yb[1:zahl[1],]
     putglobal("xxb")
     putglobal("yyb")   
     putglobal("c0")
     putglobal("c1")    
    hx = hfac*sqrt(var(xxb))*rows(xxb)^(-1/7.5)
     putglobal("hx")    
    integ[1]=simpsonint("ndw",lim1,lim2,100)
jj=2
while (jj <= nz)
     bd=sum(zahl)       
     unten=sum(zahl[1:jj,])-zahl[jj]+1
     oben=sum(zahl[1:jj,])              
     xxb = xb[unten:oben,]      
     yyb = yb[unten:oben,]
     putglobal("xxb")
     putglobal("yyb")   
     putglobal("c0")
     putglobal("c1")    
     hx = hfac*sqrt(var(xxb))*rows(xxb)^(-1/7.5)    
      putglobal("hx")   
    integ[jj]=simpsonint("ndw",lim1,lim2,100)
     jj=jj+1
endo
  di =  integ[2] - integ[1]
  jj = 3
while (jj <= nz)
    tmp = integ[jj] - integ[1]
    di = di|tmp
    jj = jj + 1
    endo
jj = 2
while (jj <= nz)
    if (jj == 2)
      w = zmat[jj,] - zmat[1,]
      else
      w = w|(zmat[jj,] - zmat[1,])
      endif
    jj = jj + 1
    endo
  alphahat = inv(w'*w)*w'*di
endp