proc(Pii)=arofva(bmat,ord,pkmax,di)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  domulti
; ----------------------------------------------------------------------
;   Macro	  arofva
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for full VAR model analysis
; ----------------------------------------------------------------------
;   Usage         Pii = arofva(bmat,ord,pkmax,di)
;   Input 
;     Parameter   bmat 
;     Definition    matrix 
;     Parameter   ord 
;     Definition    vector, order of series
;     Parameter   pkmax 
;     Definition    scalar
;     Parameter   di 
;     Definition    vector, dimensions
;   Output
;     Parameter   Pii
;     Definition    matrix
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich  971203
; ---------------------------------------------------------------------- 
ARva=bmat[,1:pkmax*di]~zeros(di,(ord-pkmax)*di)
MAva=bmat[,pkmax*di+1:cols(bmat)]~zeros(di,(ord-pkmax)*di)
Pii=ARva+MAva;
i=2;
while (i <= ord)
   sum=zeros(di,di);
   j=1;
   while (j <= i-1)
      sumi=MAva[,(i-j-1)*di+1:(i-j)*di]*Pii[,(j-1)*di+1:j*di]
      sum=sum+sumi;
      j=j+1;
   endo;
   Pii[,(i-1)*di+1:i*di]=Pii[,(i-1)*di+1:i*di]-sum;
   i=i+1;
endo
endp
