proc(bb)=bgen(b, di, ord)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  agen
; ----------------------------------------------------------------------
;   Macro	  bgen
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for full VAR model analysis
; ----------------------------------------------------------------------
;   Usage         bb = bgen(b, di, ord)
;   Input 
;     Parameter   b 
;     Definition    di*ord+1 vector 
;     Parameter   di 
;     Definition    vector, dimensions
;     Parameter   ord 
;     Definition    vector, order of series
;   Output
;     Parameter   bb
;     Definition    vector
; ----------------------------------------------------------------------
;   Example       library("multi")
;		  bb = bgen(zeros(1,5),2,2)
;                 bb
; ----------------------------------------------------------------------
;   Result  Contents of bb
;     [1,]        1        0        0        0        0 
;     [2,]        0        0        0        0        0 
;     [3,]        0        1        0        0        0 
;     [4,]        0        0        1        0        0 
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich  971027
; ---------------------------------------------------------------------- 
bb=1
error (cols(b) <> (di*ord+1), "cols of b wrong in bgen") 
if (ord>0)
(bb~zeros(1,di*ord))
  bb=(bb~zeros(1,di*ord))|b
endif
if (ord>1)
  bb=bb|(zeros(di*(ord-1),1)~eye(di*(ord-1))~zeros(di*(ord-1),di))
endif
endp
