proc(th,liks) = bigarch(theta,et)
; ---------------------------------------------------------------------
; Library     times
; ---------------------------------------------------------------------
; See_also    archest, archtest, genarch, rvlm
; ---------------------------------------------------------------------
; Macro       bigarch
; ---------------------------------------------------------------------
; Description Estimates the BEKK (Baba, Engle, Kraft, Kroner) volatility
;             representation for bivariate conditionally
;             heteroscedastic time series and evaluates the maximum of
;             the quasi log likelihood function
; ---------------------------------------------------------------------
; Usage       {th,liks}=bigarch(theta,et)
; Input       
; Parameter   theta
; Definition  columns of 2x2 ARCH and GARCH parameter matrices
; Parameter   et
; Definition  time series data, tx2
; Output      
; Parameter   th
; Definition  elements of upper triangular 2x2 matrix of deterministic
;             variance components and estimated columns of 2x2 ARCH
;             and GARCH parameter matrices
; Parameter   liks
; Definition  evaluated log likelihood function
; ---------------------------------------------------------------------
; Example     library("times")
;             theta=#(0.5, 0.01, 0.01, 0.5, 0.6, 0.01, 0.01, 0.7)
;             et=read("bigarch.dat")
;             {th, liks} = bigarch(theta, et)
;             th
;             liks
; ---------------------------------------------------------------------
; Result      Contents of th
;
;             [ 1,]  0.66929 
;             [ 2,]  0.10183 
;             [ 3,]  0.026132 
;             [ 4,]  0.37569 
;             [ 5,]  0.20174 
;             [ 6,]  -0.2142 
;             [ 7,]  0.28792 
;             [ 8,] -0.011575 
;             [ 9,] -0.02021 
;             [10,]  0.47874 
;             [11,]  0.72634 
;
;             Contents of liks
;
;             [1,]   1035.7 
; ---------------------------------------------------------------------
; Keywords    time series, heteroscedasticity, bivariate, BEKK, GARCH
; ---------------------------------------------------------------------
; Reference   Engle, R.F./Kroner, K.F., (1995): Multivariate Simultaneous
;             Generalized GARCH; Econometric Theory, 11, 122-150
; ---------------------------------------------------------------------
; Author      Helmut Herwatz, Fabian Noetzel
; ---------------------------------------------------------------------
  
  error(prod(dim(theta))<>8, "Vector theta must have 8 elements")
  nx=countNotNumber(et)
  error(sum(nx)>0, "Missings or infinite values in et")  
  
  os=getenv("os")
  if (os=="windows")
    hndl=dlopen("bigarch.dll")
  else
    hndl=dlopen("bigarch.so")
  endif
  if (theta[1] < 0)
    theta[1:4] = theta[1:4]*(-1)
  endif
  
  if (theta[5] < 0)
    theta[5:8] = theta[5:8]*(-1)
  endif
  
  a1 = theta[1:2]~theta[3:4]
  g1 = theta[5:6]~theta[7:8]  
  c0 = c0stern1(et,a1,g1)
  
  theta = c0[1,1]|c0[1,2]|c0[2,2]|a1[,1]|a1[,2]|g1[,1]|g1[,2]
  
  th = theta
  steps = 5~2~1~0.5~0.25~0.1~0.01~0.005~0
  step = 0.1
  stelle = 0
  ende2 = 0
  
  iterat = 1
  do
    
    theta = th
    theta1 = zeros(rows(theta),9)
    
    abl = anaabl(et, theta, os, hndl)
    abl2 = abl'*abl
    abl = sum(abl)
    liks = lik(et,theta, os, hndl)
    
    j = 1
    do
      temp = th - step*steps[1,j]*invv(abl2)*(abl)'
      theta1[,j]  = temp    
      j = j+1
    until (j>9)
    
    ab11 = zeros(9,1)
    ab11[9,] = liks
    ende = 0
    
    j = 8
    do 
      liks = lik(et,theta1[,j], os, hndl)     
      ab11[j,] = liks
      if (ab11[j+1,] < ab11[j,])
        ende = 1
      endif
      j = j-1
    until( (j<1) || (ende==1) )  
    
    stelle = minind((ab11[(j+1):rows(ab11),]))+j
    
    ab1 = ab11[stelle,]
//  ab11'
    if (ab1 == 99999)
      ende2 = 1
    endif
    
    if (((ab1-ab11[9,])^2/abs(ab11[9,])) < 0.000005)
      ende2 = 1
    endif
    th = theta1[,stelle]
    
    iterat = iterat+1
  until ( (ende2==1) || (iterat>50) )
  
  liks = lik(et,th, os, hndl)
  dlclose(hndl)
  
endp

