proc()=boxcoxdens(x,p)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     twboxcox
; -----------------------------------------------------------------------
; Macro        boxcoxdens
; -----------------------------------------------------------------------
; Description  shows the change in the density before and after
;              a Box-Cox transformation of x
; -----------------------------------------------------------------------
; Usage        boxcoxdens (x, p)
; Input
;   Parameter  x 
;   Definition n x q 
;   Parameter  p
;   Definition scalar
; -----------------------------------------------------------------------
; Example      ; loads the library stats
;              library("stats")
;              ; loads the library graphic
;              library("graphic")   
;              ; loads the library graphic
;              library("smoother")   
;              ; reset random generator 
;              randomize(0)
;              ; generate x (skewed)
;              x = 0.05+0.9.*uniform (250)
;              x = qfc (x, 2)
;              ; show the densities
;              boxcoxdens(x, 0)
; -----------------------------------------------------------------------
; Result       shows the density of the data before and after the
;              Box-Cox transformation.
; -----------------------------------------------------------------------
; Author       Susanne Hannappel, 970220 
;              Sigbert Klinke, 970820
; ----------------------------------------------------------------------
  setsize (900,600)
  DensityPlot = createdisplay(2,2)
  setfractions (DensityPlot, #(2,1),#(1,1))
  fhdat = denest(x)  
  xp    = boxcox(x,p)   
  fh    = denest(xp)
  setmaskp (fhdat,7,0,4)
  setmaskl (fhdat,(1:rows(fh ))',0,1,1)
  setmaskp (fhdat,7,0,4)
  setmaskl (fhdat,(1:rows(fh ))',0,1,1)
  show (DensityPlot,1,2,fhdat)
  setheadline (DensityPlot,1,2,"Your data before Box-Cox")  
  xlab = "x-original"
  ylab = "density function"
  setgopt (DensityPlot,1,2,"xlabel",xlab,"ylabel",ylab,"xorigin",-1000,"xmajor",2000,"yorigin",-1000, "ymajor",2000)
  setmaskp (fh ,7,0,4)
  setmaskl (fh,(1:rows(fhdat ))',4,1,1)
  show (DensityPlot,1,1,fh)
  text = string(" p =%.2f", p)
  head = "Your data after Box-Cox with"+text
  setheadline(DensityPlot,1,1,head)
  xlab = "x-transformed"
  setgopt (DensityPlot,1,1,"xlabel",xlab,"ylabel",ylab ,"xorigin",-1000,"xmajor",2000,"yorigin",-1000, "ymajor",2000)
; ==========      
; Comment    
; ==========   
  zero        = "       Do you like your data now?"
  zeroplus    = "        Is it SYMMETRIC enough?"
  firstline   = "      If you don't like the result,"
  secondline  = "  then maybe your data was multimodal."
  thirdline   = "              What is that?"
  out         = zero|zeroplus|""|firstline|secondline|""|""|""|thirdline
  show (DensityPlot,2,1,out)
  fourthline  = " It means that you see several 'hills'"
  fifthline   = "      in your density function"
  sixthline   = "          Is this the case?" 
  seventhline = " Sorry, you should switch too..."
  out = ""|""|""|fourthline|fifthline|""|sixthline|""|seventhline
  show (DensityPlot,2,2,out)
endp    
  
