proc (z) = cadd (x,y) 
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cdiv cmul csub
; -----------------------------------------------------------------------
; Macro        cadd
; -----------------------------------------------------------------------
; Description  Complex addition of two arrays
; -----------------------------------------------------------------------
; Usage        z = cadd (x, y)
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn complex array
;   Parameter  y 
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = cadd (complex (0, 1), complex(1, 0))
;              z
; -----------------------------------------------------------------------
; Result       Contents of z.re
; 		         [1,]        1 
;              Contents of z.im 
; 		         [1,]        1 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960327, 970530
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cadd : No real part in x found")
  error (comp(x, "im")<1, "cadd : No imaginary part in x found")
  error (comp(y, "re")<1, "cadd : No real part in y found")
  error (comp(y, "im")<1, "cadd : No imaginary part in y found")  
  re = x.re+y.re  
  im = x.im+y.im
  z = list(re, im)
endp  



