proc(h2) = canker(h1, K1, K2)
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;  See_also      uni tri trian epa qua gau cosi
; -----------------------------------------------------------------
;   Macro        canker
; -----------------------------------------------------------------
;   Keywords     kernel smoothing, canonical kernels
; -----------------------------------------------------------------
;   Description  does the canonical bandwith transformation 
;                of a bandwith value of kernel K1 into an 
;                equivalent bandwidth for Kernel K2. 
; -----------------------------------------------------------------
;   Reference    Marron/Nolan (1988): Canonical kernels for density
;                estimation
; -----------------------------------------------------------------
;   Usage        h2 = canker (h1, K1, K2)
;   Input
;     Parameter  h1 
;     Definition   array, bandwidth for K1.
;     Parameter  K1
;     Definition   string, kernel function on [-1,1] or "gau".
;     Parameter  K2
;     Definition   string, kernel function on [-1,1] or "gau".
;   Output
;     Parameter  h2  
;     Definition   array, equivalent bandwidth for K2.
; -----------------------------------------------------------------
;   Example   library("smoother") 
;             h2 = canker(1,"gau","qua")
;             h2
; -----------------------------------------------------------------
;   Result    Contents of h2
;             [1,]   2.6226 
; -----------------------------------------------------------------
;   Author    Sigbert Klinke, Berwin Turlach, Isabel Proenca 940507; 
;             Lijian Yang, 961021;  
;             Marlene Mueller, 990209
; -----------------------------------------------------------------
  tmp1=canbw(K1)
  tmp2=canbw(K2)
  h2=h1*tmp2.dK/tmp1.dK
endp          

