proc (z) = cfloor (x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cceil
; -----------------------------------------------------------------------
; Macro        cfloor
; -----------------------------------------------------------------------
; Description  Computes floor for a complex array
; -----------------------------------------------------------------------
; Usage        z = cfloor (x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = complex (1.5, -1.5)
;	             cfloor (z)
; -----------------------------------------------------------------------
; Result       Contents of z.re
;		           [1,]        1 
;	             Contents of z.im
;              [1,]       -2 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cfloor : No real part in x found")
  error (comp(x, "im")<1, "cfloor : No imaginary part in x found")
  re = floor(x.re)
  im = floor(x.im)
  z  = list(re,im)
endp

