proc(selvar)=choosevariableX(data,text,sel)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     choosegroup choosevariable choosevarable2 choosevariablep 
;              doista 
; -----------------------------------------------------------------------
; Macro        choosevariableX
; -----------------------------------------------------------------------
; Description  selction of X variables in regression context 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  if(sum(data.colvar&&data.colmissing&&(1-sel)))
    ;variable to choose has to be undeleted and not already chosen as 
    ;Yvariable
    selheadh="Select variable(s)"
    selheadh=selheadh+text
    selitemh = paf(data.colname, (data.colvar&&data.colmissing&&(1-sel)))
    selitemh = "all"|selitemh
    selind = paf(1:rows(data.colname), (data.colvar&&data.colmissing&&(1-sel)))
    selvar = 0.*matrix(rows(data.colname))
    sel = selectitemlist(selheadh,selitemh,15)
    r=rows(sel)
    if (sel[1]==1) 
      selvar[selind]=1*matrix(r-1)
    else
      selvar[selind] = sel[2:r]
    endif    
  else
    selvar = 0.*matrix(cols(data.colname))
  endif
endp  